/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.communications.tcpip;

import com.valhalanetworks.utils.communications.Transporter;
import com.valhalanetworks.utils.communications.utils.SyncroBuffer;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import com.valhalanetworks.utils.vthreads.annotations.ThreadSafe;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

@ThreadSafe
public class TcpIpClient
implements Transporter,
Runnable {
    private final String Host;
    private final int Port;
    @GuardedBy(value="this")
    private DataInputStream is;
    @GuardedBy(value="this")
    private DataOutputStream os;
    @GuardedBy(value="this")
    private Socket clientSocket = null;
    private Thread Receptor = null;
    private boolean RunReceptor;
    @GuardedBy(value="this")
    private SyncroBuffer Buffer;
    private int ReceiveBufferSize;
    private int SendBufferSize;
    private boolean KeepAlive;
    private int TrafficClass;
    private boolean TcpNoDelay;
    private LoggerManager Bitacora;
    public static final int IPTOS_LOWCOST = 2;
    public static final int IPTOS_RELIABILITY = 4;
    public static final int IPTOS_THROUGHPUT = 8;
    public static final int IPTOS_LOWDELAY = 16;
    public static final int ERROR_UNKNOWHOST = 1;
    public static final int ERROR_IO = 2;
    public static final int ERROR_SENDDATA = 3;
    public static final int ERROR_INTERFACE = 4;

    public TcpIpClient(String Host, int Port) {
        this.Host = Host;
        this.Port = Port;
        this.ReceiveBufferSize = 8192;
        this.SendBufferSize = 8192;
        this.KeepAlive = false;
        this.TrafficClass = 2;
        this.TcpNoDelay = false;
        this.Bitacora = null;
    }

    public void setBitacora(LoggerManager Bitacora) {
        this.Bitacora = Bitacora;
    }

    public int getTrafficClass() throws UtilsException {
        if (this.clientSocket != null) {
            try {
                this.TrafficClass = this.clientSocket.getTrafficClass();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the Traffic Class the socket", 4);
            }
        }
        return this.TrafficClass;
    }

    public void setTrafficClass(int TrafficClass) throws UtilsException {
        if (TrafficClass >= 0 && TrafficClass <= 255) {
            if (this.clientSocket != null) {
                try {
                    this.TrafficClass = TrafficClass;
                    this.clientSocket.setTrafficClass(this.TrafficClass);
                }
                catch (SocketException ex) {
                    throw new UtilsException("ERROR: Can't set Traffic Class to " + Integer.toString(TrafficClass), 4);
                }
            } else {
                this.TrafficClass = TrafficClass;
            }
        }
    }

    public void setReceiveBufferSize(int ReceiveBufferSize) throws UtilsException {
        if (ReceiveBufferSize > 0) {
            if (this.clientSocket != null) {
                try {
                    this.ReceiveBufferSize = ReceiveBufferSize;
                    this.clientSocket.setReceiveBufferSize(this.ReceiveBufferSize);
                }
                catch (SocketException ex) {
                    throw new UtilsException("ERROR: Can't set Recive Buffer Size to " + Integer.toString(ReceiveBufferSize) + " kbps ", 4);
                }
            } else {
                this.ReceiveBufferSize = ReceiveBufferSize;
            }
        }
    }

    public void setSendBufferSize(int SendBufferSize) throws UtilsException {
        if (SendBufferSize > 0) {
            if (this.clientSocket != null) {
                try {
                    this.SendBufferSize = SendBufferSize;
                    this.clientSocket.setReceiveBufferSize(this.SendBufferSize);
                }
                catch (SocketException ex) {
                    throw new UtilsException("ERROR: Can't set Send Buffer Size to " + Integer.toString(SendBufferSize) + " kbps ", 4);
                }
            } else {
                this.SendBufferSize = SendBufferSize;
            }
        }
    }

    public void setKeepAlive(boolean KeepAlive) throws UtilsException {
        if (this.clientSocket != null) {
            try {
                this.KeepAlive = KeepAlive;
                this.clientSocket.setKeepAlive(this.KeepAlive);
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't set Socket KeepAlive", 4);
            }
        } else {
            this.KeepAlive = KeepAlive;
        }
    }

    public int getReceiveBufferSize() throws UtilsException {
        if (this.clientSocket != null) {
            try {
                this.ReceiveBufferSize = this.clientSocket.getReceiveBufferSize();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the Revice Buffer Size at the socket", 4);
            }
        }
        return this.ReceiveBufferSize;
    }

    public int getSendBufferSize() throws UtilsException {
        if (this.clientSocket != null) {
            try {
                this.SendBufferSize = this.clientSocket.getSendBufferSize();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the Send Buffer Size at the socket", 4);
            }
        }
        return this.SendBufferSize;
    }

    public boolean isKeepAlive() throws UtilsException {
        if (this.clientSocket != null) {
            try {
                this.KeepAlive = this.clientSocket.getKeepAlive();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the Keep Alive status at the socket", 4);
            }
        }
        return this.KeepAlive;
    }

    public void setTCPNoDelay(boolean TcpNoDelay) throws UtilsException {
        if (this.clientSocket != null) {
            try {
                this.TcpNoDelay = TcpNoDelay;
                this.clientSocket.setTcpNoDelay(this.TcpNoDelay);
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't set Socket TcpNoDelay", 4);
            }
        } else {
            this.TcpNoDelay = TcpNoDelay;
        }
    }

    public boolean isTCPNoDelay() throws UtilsException {
        if (this.clientSocket != null) {
            try {
                this.TcpNoDelay = this.clientSocket.getTcpNoDelay();
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Can't get the TcpNoDelay status at the socket", 4);
            }
        }
        return this.TcpNoDelay;
    }

    public String getHost() {
        return this.Host;
    }

    public int getPort() {
        return this.Port;
    }

    @Override
    public synchronized void Send(byte[] Datos) throws UtilsException {
        try {
            this.os.write(Datos, 0, Datos.length);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: Error al enviar datos al Host " + this.Host + " " + ex.getLocalizedMessage(), 3);
        }
    }

    @Override
    public synchronized byte[] Recive() {
        byte[] Datos = this.Buffer.getall();
        return Datos;
    }

    @Override
    public synchronized boolean DataAvailable() {
        boolean Salida = false;
        if (this.Buffer.length() > 0) {
            Salida = true;
        }
        return Salida;
    }

    @Override
    public int TransporterTypeID() {
        return 1;
    }

    @Override
    public synchronized void Open() throws UtilsException {
        this.Buffer = new SyncroBuffer();
        try {
            this.clientSocket = new Socket(this.Host, this.Port);
            this.clientSocket.setKeepAlive(this.KeepAlive);
            this.clientSocket.setTcpNoDelay(this.TcpNoDelay);
            this.clientSocket.setReceiveBufferSize(this.ReceiveBufferSize);
            this.clientSocket.setSendBufferSize(this.SendBufferSize);
            this.clientSocket.setTrafficClass(this.TrafficClass);
            this.is = new DataInputStream(this.clientSocket.getInputStream());
            this.os = new DataOutputStream(this.clientSocket.getOutputStream());
        }
        catch (UnknownHostException ex) {
            throw new UtilsException("ERROR: Host " + this.Host + " Desconocido ", 1);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: Conexion con el Host " + this.Host + " " + ex.getLocalizedMessage(), 2);
        }
        this.RunReceptor = true;
        this.Receptor = new Thread(this);
        boolean ChangeThead = true;
        try {
            this.Receptor.checkAccess();
        }
        catch (SecurityException ex) {
            ChangeThead = false;
        }
        if (ChangeThead) {
            int Priority = this.Receptor.getPriority() - 2;
            if (Priority < 1) {
                Priority = 1;
            }
            this.Receptor.setPriority(Priority);
        }
        this.Receptor.start();
    }

    @Override
    public synchronized void Close() throws UtilsException {
        if (this.Receptor != null) {
            this.RunReceptor = false;
        }
        try {
            this.is.close();
            this.os.close();
            this.clientSocket.close();
            this.clientSocket = null;
            this.is = null;
            this.os = null;
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: Al cerrar conexion con el Host " + this.Host + " " + ex.getLocalizedMessage(), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MersenneTwisterPlus Aleatorio = new MersenneTwisterPlus();
        while (this.RunReceptor) {
            try {
                int NumBytes = 0;
                do {
                    TcpIpClient tcpIpClient = this;
                    synchronized (tcpIpClient) {
                        if (this.is != null) {
                            NumBytes = this.is.available();
                        }
                    }
                    if (NumBytes >= 1 || !this.RunReceptor) continue;
                    try {
                        Thread.sleep(100 + Math.abs(Aleatorio.nextInt()) % 400);
                    }
                    catch (InterruptedException ex) {
                        if (this.Bitacora == null) {
                            Logger.getLogger(TcpIpClient.class.getName()).log(Level.SEVERE, null, ex);
                            continue;
                        }
                        this.Bitacora.LogMessage(2, 64, TcpIpClient.class.getName(), "ERROR: Thread Sleeper Fail");
                    }
                } while (NumBytes < 1 && this.RunReceptor);
                if (!this.RunReceptor) continue;
                byte[] BufferByte = new byte[NumBytes];
                TcpIpClient ex = this;
                synchronized (ex) {
                    if (this.is != null) {
                        this.is.read(BufferByte, 0, NumBytes);
                        this.Buffer.put(BufferByte);
                    }
                }
            }
            catch (IOException ex) {
                if (this.Bitacora == null) {
                    Logger.getLogger(TcpIpClient.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                this.Bitacora.LogMessage(2, 64, TcpIpClient.class.getName(), "ERROR: Thread RUN Fail");
            }
        }
    }

    @Override
    public int getMTU() throws UtilsException {
        int MTU = -1;
        if (this.clientSocket.isBound()) {
            NetworkInterface Interfaz;
            try {
                Interfaz = NetworkInterface.getByInetAddress(this.clientSocket.getLocalAddress());
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Al obtener la interface:" + ex.getLocalizedMessage(), 4);
            }
            try {
                MTU = Interfaz.getMTU();
                MTU -= 40;
            }
            catch (SocketException ex) {
                throw new UtilsException("ERROR: Al obtener el MTU de la interface:" + ex.getLocalizedMessage(), 4);
            }
        }
        return MTU;
    }
}

