/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.math;

import com.valhalanetworks.utils.exception.UtilsException;

public strictfp class MathUtil {
    public static final int NumDecimalsLessThanZero = 3;

    private MathUtil() {
    }

    public static double roundToDecimals(double d, int numeroDecimales) throws UtilsException {
        double decimal = d;
        if (numeroDecimales >= 0) {
            decimal *= Math.pow(10.0, numeroDecimales);
        } else {
            throw new UtilsException("ERROR: Decimals to round is less that Zero", 3);
        }
        decimal = Math.round(decimal);
        return decimal /= Math.pow(10.0, numeroDecimales);
    }

    public static long[] DoubleToRational(double x) {
        long[] Fraction = null;
        double tolerance = 1.0E-7;
        Fraction = new long[2];
        long Signum = (long)Math.signum(x);
        if ((x = Math.abs(x)) > 0.0) {
            double h1 = 1.0;
            double h2 = 0.0;
            double k1 = 0.0;
            double k2 = 1.0;
            double b = x;
            do {
                double a = Math.floor(b);
                double aux = h1;
                h1 = a * h1 + h2;
                h2 = aux;
                aux = k1;
                k1 = a * k1 + k2;
                k2 = aux;
                b = 1.0 / (b - a);
            } while (Math.abs(x - h1 / k1) > x * tolerance);
            Fraction[0] = (long)h1;
            Fraction[1] = (long)k1;
        } else {
            Fraction[0] = 0L;
            Fraction[1] = 1L;
        }
        Fraction[0] = Fraction[0] * Signum;
        return Fraction;
    }
}

