/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.numericalalgorith;

import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.numericalalgorith.Matrix;
import java.util.logging.Level;
import java.util.logging.Logger;

public strictfp class KalmanFilter {
    public static final int EMPTY_MATRIX = 1;
    public static final int ROW_OUT_RANGE = 2;
    public static final int COLUMN_OUT_RANGE = 3;
    public static final int ROWS_OF_MATRIXS_DONT_MATCH = 4;
    public static final int COLUMNS_OF_MATRIXS_DONT_MATCH = 5;
    public static final int PARAMETER_NULL = 6;
    public static final int COLUMNS_ROW_OF_MATRIXS_DONT_MATCH = 7;
    public static final int NOT_SQUARE_MATRIX = 8;
    public static final int SINGULAR_MATRIX = 9;
    Matrix A;
    Matrix B;
    Matrix H;
    Matrix Q;
    Matrix R;
    Matrix I;
    Matrix Xn;
    Matrix Pn;

    public KalmanFilter() {
        this.A = null;
        this.B = null;
        this.H = null;
        this.Q = null;
        this.R = null;
        this.I = null;
        this.Xn = null;
        this.Pn = null;
    }

    public KalmanFilter(Matrix A, Matrix B, Matrix H, Matrix Q, Matrix R) {
        this.A = new Matrix(A);
        this.B = new Matrix(B);
        this.H = new Matrix(H);
        this.Q = new Matrix(Q);
        this.R = new Matrix(R);
        this.I = new Matrix(H.getRowsNumber(), H.getColumnNumber());
        try {
            this.I.InitIdentidad();
        }
        catch (UtilsException ex) {
            Logger.getLogger(KalmanFilter.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.Pn = new Matrix(this.I);
        this.Xn = null;
    }

    public Matrix getA() {
        return new Matrix(this.A);
    }

    public void setA(Matrix A) {
        this.A = new Matrix(A);
    }

    public Matrix getB() {
        return new Matrix(this.B);
    }

    public void setB(Matrix B) {
        this.B = new Matrix(B);
    }

    public Matrix getH() {
        return new Matrix(this.H);
    }

    public void setH(Matrix H) {
        this.H = new Matrix(H);
    }

    public Matrix getQ() {
        return new Matrix(this.Q);
    }

    public void setQ(Matrix Q) {
        this.Q = new Matrix(Q);
    }

    public Matrix getR() {
        return new Matrix(this.R);
    }

    public void setR(Matrix R) {
        this.R = new Matrix(R);
    }

    public Matrix Estimate(Matrix Zn, Matrix Un) throws UtilsException {
        if (this.I == null) {
            if (this.H != null) {
                this.I = new Matrix(this.H.getRowsNumber(), this.H.getColumnNumber());
                this.I.InitIdentidad();
            } else {
                throw new UtilsException("ERROR: La Matriz H es nula", 6);
            }
        }
        Matrix Xp = this.A.Multi(this.Xn);
        Matrix Temp = this.B.Multi(Un);
        Xp = Xp.Add(Temp);
        Matrix Pp = this.A.Multi(this.Pn);
        Pp = Pp.Multi(this.A.Trans());
        Pp = Pp.Add(this.Q);
        Matrix Y = Zn.Subtrac(this.H.Multi(Xp));
        Matrix S = this.H.Multi(Pp);
        S = S.Multi(this.H.Trans());
        S = S.Add(this.R);
        Matrix K = Pp.Multi(this.H.Trans());
        K = K.Multi(S.Inv());
        Temp = K.Multi(Y);
        this.Xn = Xp.Add(Temp);
        Temp = this.I.Subtrac(K.Multi(this.H));
        this.Pn = Temp.Multi(Pp);
        return new Matrix(this.Xn);
    }

    public Matrix getPn() {
        if (this.Pn != null) {
            return new Matrix(this.Pn);
        }
        return null;
    }

    public void setPn(Matrix Pn) {
        this.Pn = new Matrix(Pn);
    }

    public Matrix getXn() {
        if (this.Xn != null) {
            return new Matrix(this.Xn);
        }
        return null;
    }

    public void setXn(Matrix Xn) {
        this.Xn = new Matrix(Xn);
    }
}

