/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.crypto.cuaimacrypt.utils;

import com.valhalanetworks.crypto.cuaimacrypt.CuaimaCrypt;
import com.valhalanetworks.crypto.digest.BaseHash;
import com.valhalanetworks.crypto.digest.CRC32;
import com.valhalanetworks.crypto.digest.CRC64;
import com.valhalanetworks.crypto.digest.Has160;
import com.valhalanetworks.crypto.digest.Haval;
import com.valhalanetworks.crypto.digest.MD2;
import com.valhalanetworks.crypto.digest.MD4;
import com.valhalanetworks.crypto.digest.MD5;
import com.valhalanetworks.crypto.digest.RipeMD128;
import com.valhalanetworks.crypto.digest.RipeMD160;
import com.valhalanetworks.crypto.digest.Sha0;
import com.valhalanetworks.crypto.digest.Sha160;
import com.valhalanetworks.crypto.digest.Sha224;
import com.valhalanetworks.crypto.digest.Sha256;
import com.valhalanetworks.crypto.digest.Sha384;
import com.valhalanetworks.crypto.digest.Sha512;
import com.valhalanetworks.crypto.digest.Tiger;
import com.valhalanetworks.crypto.digest.Tiger128;
import com.valhalanetworks.crypto.digest.Tiger160;
import com.valhalanetworks.crypto.digest.Tiger2;
import com.valhalanetworks.crypto.digest.Whirlpool;
import com.valhalanetworks.crypto.digest.Whirlpool2000;
import com.valhalanetworks.crypto.digest.Whirlpool2003;
import com.valhalanetworks.crypto.interfaces.CryptoBinary;
import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.converters.Converter;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class CuaimaBinary
implements CryptoBinary {
    private CuaimaCrypt CCPT;
    private int PasswdLength;
    private double HeadPos;
    private static final short VERSION = 3;
    private static final int HASHMASK = 62;
    public static final int ERROR_NUMBLCK = 3;

    private strictfp void CalcHeadPos(String Password) {
        long Temp = 0L;
        for (int i = 0; i < Password.length(); ++i) {
            Temp += (long)Password.charAt(i);
        }
        this.HeadPos = Temp;
        this.HeadPos /= 100.0;
        Temp = (long)this.HeadPos;
        this.HeadPos -= (double)Temp;
    }

    public CuaimaBinary() {
        this.PasswdLength = -1;
        this.CCPT = new CuaimaCrypt();
    }

    public CuaimaBinary(int NumBlocks) throws UtilsException {
        this.PasswdLength = -1;
        if (NumBlocks < 2) {
            throw new UtilsException("ERROR: NO se pudo inicializar CuaimaText, la cantidad de bloques es menor a 2", 3);
        }
        this.CCPT = new CuaimaCrypt(NumBlocks);
    }

    public CuaimaBinary(String Password) throws UtilsException {
        this.CCPT = new CuaimaCrypt();
        if (this.CCPT.Password(Password) != 0) {
            this.PasswdLength = -1;
            throw new UtilsException("ERROR: NO se pudo inicializar CuaimaText, falla al inicializar el Password", 4);
        }
        this.PasswdLength = Password.length();
        this.CalcHeadPos(Password);
    }

    public CuaimaBinary(String Password, int NumBlocks) throws UtilsException {
        if (NumBlocks < 2) {
            throw new UtilsException("ERROR: NO se pudo inicializar CuaimaText, la cantidad de bloques es menor a 2", 3);
        }
        this.CCPT = new CuaimaCrypt(NumBlocks);
        if (this.CCPT.Password(Password) != 0) {
            this.PasswdLength = -1;
            throw new UtilsException("ERROR: NO se pudo inicializar CuaimaText, falla al inicializar con el Password", 4);
        }
        this.PasswdLength = Password.length();
        this.CalcHeadPos(Password);
    }

    @Override
    public boolean Password(String Passw) throws UtilsException {
        boolean salida = false;
        this.PasswdLength = -1;
        if (this.CCPT != null) {
            if (this.CCPT.Password(Passw) != 0) {
                throw new UtilsException("ERROR: NO se pudo inicializar la clave en CuaimaText", 4);
            }
            this.PasswdLength = Passw.length();
            this.CalcHeadPos(Passw);
            salida = true;
        }
        return salida;
    }

    public void Reset() {
        if (this.PasswdLength > 0) {
            this.CCPT.Reset();
        }
    }

    @Override
    public byte[] Codec(byte[] Input, int Opciones) throws UtilsException {
        long[] CodecBuffer;
        byte[] Salida = null;
        byte[] k = null;
        if (this.PasswdLength > 0) {
            long[] A;
            int i;
            int j;
            byte[] Digest;
            BaseHash Hash;
            MersenneTwisterPlus Rand = new MersenneTwisterPlus();
            this.CCPT.Reset();
            int HashType = Opciones & 0x3E;
            switch (HashType) {
                case 2: {
                    Hash = new Whirlpool2003();
                    break;
                }
                case 4: {
                    Hash = new Whirlpool2000();
                    break;
                }
                case 6: {
                    Hash = new Whirlpool();
                    break;
                }
                case 8: {
                    Hash = new Sha0();
                    break;
                }
                case 10: {
                    Hash = new Sha160();
                    break;
                }
                case 12: {
                    Hash = new Sha224();
                    break;
                }
                case 14: {
                    Hash = new Sha256();
                    break;
                }
                case 16: {
                    Hash = new Sha384();
                    break;
                }
                case 18: {
                    Hash = new Sha512();
                    break;
                }
                case 20: {
                    Hash = new Tiger();
                    break;
                }
                case 22: {
                    Hash = new Tiger2();
                    break;
                }
                case 24: {
                    Hash = new Tiger128();
                    break;
                }
                case 26: {
                    Hash = new Tiger160();
                    break;
                }
                case 28: {
                    Hash = new RipeMD128();
                    break;
                }
                case 30: {
                    Hash = new RipeMD160();
                    break;
                }
                case 32: {
                    Hash = new MD2();
                    break;
                }
                case 34: {
                    Hash = new MD4();
                    break;
                }
                case 36: {
                    Hash = new MD5();
                    break;
                }
                case 38: {
                    Hash = new Haval(16);
                    break;
                }
                case 40: {
                    Hash = new Haval(20);
                    break;
                }
                case 42: {
                    Hash = new Haval(24);
                    break;
                }
                case 44: {
                    Hash = new Haval(28);
                    break;
                }
                case 46: {
                    Hash = new Haval(32);
                    break;
                }
                case 48: {
                    Hash = new Has160();
                    break;
                }
                case 50: {
                    Hash = new CRC32();
                    break;
                }
                case 52: {
                    Hash = new CRC64();
                    break;
                }
                case 0: {
                    Hash = null;
                    break;
                }
                default: {
                    Hash = new Whirlpool2003();
                }
            }
            if (HashType != 0) {
                k = Hash.Hash(Input);
                Digest = new byte[Input.length];
                ArrayUtils.arrayCopy(Input, 0, Digest, 0, Input.length);
                Digest = (byte[])ArrayUtils.resizeArray(Digest, Digest.length + Hash.hashSize());
                j = 0;
                for (i = Digest.length - Hash.hashSize(); i < Digest.length; ++i) {
                    Digest[i] = k[j];
                    ++j;
                }
            } else {
                Digest = new byte[Input.length];
                ArrayUtils.arrayCopy(Input, 0, Digest, 0, Input.length);
            }
            long[] Header = new long[]{Rand.nextLong() << 32 | Converter.byte2long(new String("CCPTTPCC").getBytes(StandardCharsets.US_ASCII))[0] >>> 32, Converter.byte2long(new String("CCPTTPCC").getBytes(StandardCharsets.US_ASCII))[0] << 32 | Rand.nextLong() >>> 32, Input.length, Rand.nextLong() << 32};
            Header[3] = Header[3] | (long)(HashType << 26);
            Header[3] = Header[3] | 3L;
            CodecBuffer = new long[(int)((double)Header.length + 2.0 * Math.ceil(Math.ceil((double)Digest.length / 8.0) / 2.0))];
            double Temp = this.HeadPos;
            long HPosc = (long)(Temp *= (double)CodecBuffer.length);
            if ((long)CodecBuffer.length - (HPosc = (long)(2.0 * Math.ceil((double)HPosc / 2.0))) < (long)Header.length) {
                HPosc = CodecBuffer.length - Header.length;
            }
            for (i = 0; i < Header.length; ++i) {
                CodecBuffer[(int)(HPosc + (long)i)] = Header[i];
            }
            k = new byte[8];
            long BufferPost = HPosc + (long)Header.length;
            for (i = Header.length; i < CodecBuffer.length; ++i) {
                if (BufferPost == (long)CodecBuffer.length) {
                    BufferPost = 0L;
                }
                for (j = 0; j < 8; ++j) {
                    k[j] = 8 * (i - Header.length) + j < Digest.length ? Digest[8 * (i - Header.length) + j] : Rand.nextByte();
                }
                A = Converter.byte2long(k);
                CodecBuffer[(int)BufferPost] = A[0];
                ++BufferPost;
            }
            A = new long[2];
            BufferPost = HPosc;
            for (i = 0; i < CodecBuffer.length; i += 2) {
                if (BufferPost == (long)CodecBuffer.length) {
                    BufferPost = 0L;
                }
                A[0] = CodecBuffer[(int)BufferPost];
                A[1] = CodecBuffer[(int)BufferPost + 1];
                this.CCPT.Codec(A);
                CodecBuffer[(int)BufferPost] = A[0];
                CodecBuffer[(int)BufferPost + 1] = A[1];
                BufferPost += 2L;
            }
        } else {
            throw new UtilsException("ERROR: NO se puede codificar el texto porque no se ha establecido una Password", 4);
        }
        Salida = Converter.long2byte(CodecBuffer);
        return Salida;
    }

    @Override
    public byte[] Decodec(byte[] Input) throws UtilsException {
        byte[] Salida = null;
        long[] DecodecBuffer = null;
        byte[] OrgDigest = null;
        byte[] NewDigest = null;
        if (this.PasswdLength > 0) {
            int i;
            this.CCPT.Reset();
            int HashType = 0;
            DecodecBuffer = Converter.byte2long(Input);
            long[] Header = new long[4];
            double Temp = this.HeadPos;
            long HPosc = (long)(Temp *= (double)DecodecBuffer.length);
            HPosc = (long)(2.0 * Math.ceil((double)HPosc / 2.0));
            if ((long)DecodecBuffer.length - HPosc < (long)Header.length) {
                HPosc = DecodecBuffer.length - Header.length;
            }
            long[] A = new long[2];
            long BufferPost = HPosc;
            for (i = 0; i < DecodecBuffer.length; i += 2) {
                if (BufferPost == (long)DecodecBuffer.length) {
                    BufferPost = 0L;
                }
                A[0] = DecodecBuffer[(int)BufferPost];
                A[1] = DecodecBuffer[(int)BufferPost + 1];
                this.CCPT.Decodec(A);
                DecodecBuffer[(int)BufferPost] = A[0];
                DecodecBuffer[(int)BufferPost + 1] = A[1];
                BufferPost += 2L;
            }
            for (i = 0; i < Header.length; ++i) {
                Header[i] = DecodecBuffer[(int)(HPosc + (long)i)];
            }
            long[] HTemp = new long[]{Header[0] << 32 | Header[1] >>> 32};
            String HeaderDec = new String(Converter.long2byte(HTemp), StandardCharsets.US_ASCII);
            if (HeaderDec.contentEquals(new StringBuffer("CCPTTPCC"))) {
                int Version = (int)(Header[3] & 0xFFL);
                if (Version == 3) {
                    BaseHash Hash;
                    HashType = (int)(Header[3] >>> 26) & 0x3E;
                    switch (HashType) {
                        case 2: {
                            Hash = new Whirlpool2003();
                            break;
                        }
                        case 4: {
                            Hash = new Whirlpool2000();
                            break;
                        }
                        case 6: {
                            Hash = new Whirlpool();
                            break;
                        }
                        case 8: {
                            Hash = new Sha0();
                            break;
                        }
                        case 10: {
                            Hash = new Sha160();
                            break;
                        }
                        case 12: {
                            Hash = new Sha224();
                            break;
                        }
                        case 14: {
                            Hash = new Sha256();
                            break;
                        }
                        case 16: {
                            Hash = new Sha384();
                            break;
                        }
                        case 18: {
                            Hash = new Sha512();
                            break;
                        }
                        case 20: {
                            Hash = new Tiger();
                            break;
                        }
                        case 22: {
                            Hash = new Tiger2();
                            break;
                        }
                        case 24: {
                            Hash = new Tiger128();
                            break;
                        }
                        case 26: {
                            Hash = new Tiger160();
                            break;
                        }
                        case 28: {
                            Hash = new RipeMD128();
                            break;
                        }
                        case 30: {
                            Hash = new RipeMD160();
                            break;
                        }
                        case 32: {
                            Hash = new MD2();
                            break;
                        }
                        case 34: {
                            Hash = new MD4();
                            break;
                        }
                        case 36: {
                            Hash = new MD5();
                            break;
                        }
                        case 38: {
                            Hash = new Haval(16);
                            break;
                        }
                        case 40: {
                            Hash = new Haval(20);
                            break;
                        }
                        case 42: {
                            Hash = new Haval(24);
                            break;
                        }
                        case 44: {
                            Hash = new Haval(28);
                            break;
                        }
                        case 46: {
                            Hash = new Haval(32);
                            break;
                        }
                        case 48: {
                            Hash = new Has160();
                            break;
                        }
                        case 50: {
                            Hash = new CRC32();
                            break;
                        }
                        case 52: {
                            Hash = new CRC64();
                            break;
                        }
                        case 0: {
                            Hash = null;
                            break;
                        }
                        default: {
                            Hash = new Whirlpool2003();
                        }
                    }
                    byte[] OutBuffer = Hash != null ? new byte[(int)Header[2] + Hash.hashSize()] : new byte[(int)Header[2]];
                    BufferPost = HPosc + (long)Header.length;
                    for (i = 0; i < OutBuffer.length; i += 8) {
                        if (BufferPost == (long)DecodecBuffer.length) {
                            BufferPost = 0L;
                        }
                        HTemp[0] = DecodecBuffer[(int)BufferPost];
                        ArrayUtils.arrayCopy(Converter.long2byte(HTemp), 0, OutBuffer, i, 8);
                        ++BufferPost;
                    }
                    if (Hash != null) {
                        OrgDigest = (byte[])ArrayUtils.subArray(OutBuffer, (int)Header[2], Hash.hashSize());
                    }
                    OutBuffer = (byte[])ArrayUtils.resizeArray(OutBuffer, (int)Header[2]);
                    Salida = new byte[OutBuffer.length];
                    ArrayUtils.arrayCopy(OutBuffer, 0, Salida, 0, OutBuffer.length);
                    if (Hash != null && !Arrays.equals(OrgDigest, NewDigest = Hash.Hash(OutBuffer))) {
                        Salida = null;
                        throw new UtilsException("ERROR: HASH NO COINCIDEN", 1);
                    }
                } else {
                    throw new UtilsException("ERROR: Version de CuaimaText NO Reconocida", 2);
                }
            }
        }
        return Salida;
    }
}

