/*
 * Decompiled with CFR 0.152.
 */
package cuaimacommand;

import com.valhalanetworks.crypto.aes.utils.AESFile;
import com.valhalanetworks.crypto.aes.utils.AESText;
import com.valhalanetworks.crypto.cuaimacrypt.utils.CuaimaFile;
import com.valhalanetworks.crypto.cuaimacrypt.utils.CuaimaText;
import com.valhalanetworks.crypto.interfaces.CryptoText;
import com.valhalanetworks.security.ValhalaObfuscator;
import com.valhalanetworks.utils.console.ProgressBar;
import com.valhalanetworks.utils.environment.EnvironmentUtils;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.files.FileManager;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.log.SimpleLogger;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CuaimaCommand
implements ClipboardOwner {
    private static final String JRE_VERSION = "1.7.0_40";
    private static final String VERSION = "5.0.0";
    private static final String COPYRIGHT = "Copyright 2015 Valhala Networks INC";
    private static LoggerManager Log;
    private static final int CONSOLEBUFFERSIZE = 0x3200000;

    private static void PrintHelp(Options CLIoptions) {
        HelpFormatter formatter = new HelpFormatter();
        CuaimaCommand.PrintVersion();
        CuaimaCommand.PrintDescription();
        formatter.printHelp("CuaimaCommand", "\n ", CLIoptions, "\nCopyright 2015 Valhala Networks INC", true);
    }

    private static void PrintDescription() {
        System.out.println("CuaimaCommand, a simple console file and text encryption utility.\n\nThis utility encrypt and dencrypt one file or text using CuaimaCrypt or CuaimaAES,\nit use one password from 1 character to generate the keys to encrypt the file.\nThis utility also can obfuscate and deobfuscate a text using Valhala's Obfuscator Algorithm.\n");
    }

    private static void PrintVersion() {
        System.out.println("CuaimaCommand v5.0.0");
    }

    private static void PrintCopyright() {
        System.out.println(COPYRIGHT);
    }

    private void setClipboardContents(String aString) {
        StringSelection stringSelection = new StringSelection(aString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }
        return result;
    }

    private static FileManager ProcessFile(boolean FCodec, FileManager InputFile, String Clave, boolean FVerbose, int EncryptAlg, int Blocks) {
        String Message;
        FileManager OutputFile = null;
        Runnable Crypto = null;
        if (Clave.length() < 1) {
            Message = "ERROR: Password MUST have at least ONE character";
            if (Log != null) {
                Log.LogMessage(2, 128, CuaimaCommand.class.getName(), Message);
            } else {
                Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, Message);
            }
            System.exit(3);
        }
        if (FVerbose) {
            System.out.print("\n");
            CuaimaCommand.PrintVersion();
            System.out.print("Generating Keys...\n");
        }
        long start_time = System.nanoTime();
        try {
            switch (EncryptAlg) {
                case 0: {
                    Crypto = new CuaimaFile(Clave, Blocks, Log);
                    break;
                }
                case 1: {
                    Crypto = new AESFile(Clave, Log);
                    break;
                }
                default: {
                    Crypto = new CuaimaFile(Clave, Blocks, Log);
                    break;
                }
            }
        }
        catch (UtilsException ex) {
            if (Log != null) {
                Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
            } else {
                Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            System.exit(3);
        }
        if (Crypto != null) {
            if (FCodec) {
                Crypto.Codec(InputFile, OutputFile, 1);
            } else {
                Crypto.Decodec(InputFile, OutputFile);
            }
            while (OutputFile == null || OutputFile.getAbsoluteFilePath() == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    if (Log != null) {
                        Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
                    }
                    Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                }
                OutputFile = Crypto.getOutputFile();
            }
            if (FVerbose) {
                ProgressBar TR = new ProgressBar();
                if (EncryptAlg == 0) {
                    Message = "CuaimaCrypt Blocks: " + String.valueOf(Blocks);
                    System.out.println(Message);
                }
                Message = "Input File: " + InputFile.getAbsoluteFilePath();
                System.out.println(Message);
                Message = FCodec ? "Encrypted File: " + OutputFile.getAbsoluteFilePath() : "Dencrypted File: " + OutputFile.getAbsoluteFilePath();
                System.out.println(Message);
                while (!Crypto.isDone()) {
                    Message = TR.PlotProgressBar(Crypto.Progress());
                    if (Message.equals("")) continue;
                    System.out.print(Message);
                }
                long end_time = System.nanoTime();
                double difference = (double)(end_time - start_time) / 1.0E9;
                System.out.println(TR.PlotProgressBar(Crypto.Progress()));
                if (FCodec) {
                    System.out.print("\nEncryption Time: " + Double.toString(difference) + " sec \n");
                } else {
                    System.out.print("\nDencryption Time: " + Double.toString(difference) + " sec \n");
                }
            } else {
                while (!Crypto.isDone()) {
                }
            }
        }
        return OutputFile;
    }

    private static int ConsoleMode(String Clave, boolean FVerbose, int EncryptAlg, int Blocks) {
        int i;
        int EndEncrypted;
        double difference;
        long end_time;
        CryptoText Crypto;
        String Linea;
        CuaimaCommand ClipBoard = new CuaimaCommand();
        long start_time = 0L;
        Console Consola = null;
        BufferedReader Reader2 = null;
        Consola = System.console();
        if (Consola == null && (Reader2 = new BufferedReader(new InputStreamReader(System.in))) == null) {
            if (Log != null) {
                Log.LogMessage(2, 128, CuaimaCommand.class.getName(), "Can't get console connection");
            } else {
                System.err.println("Can't get console connection");
            }
            return 1;
        }
        if (FVerbose) {
            if (Consola != null) {
                Consola.printf("Console Mode: ON\n", new Object[0]);
                if (FVerbose) {
                    Consola.printf("Verbose Mode: ON\n", new Object[0]);
                } else {
                    Consola.printf("Verbose Mode: OFF\n", new Object[0]);
                }
            } else {
                System.out.print("Console Mode: ON\n");
                System.out.print("Input Stream Mode: ON\n");
                System.out.print("Verbose Mode: ON\n");
            }
        }
        if (Clave == null) {
            if (Consola != null) {
                Consola.printf("Password: ", new Object[0]);
                Clave = new String(Consola.readPassword());
            } else {
                System.out.print("Password: ");
                try {
                    Linea = Reader2.readLine();
                }
                catch (IOException ex) {
                    if (Log != null) {
                        Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
                    } else {
                        Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                    }
                    return 1;
                }
            }
        }
        if (FVerbose) {
            if (Consola != null) {
                Consola.printf("\n", new Object[0]);
                CuaimaCommand.PrintVersion();
                if (EncryptAlg == 0) {
                    Consola.printf("CuaimaCrypt Blocks: " + String.valueOf(Blocks) + "\n", new Object[0]);
                }
                Consola.printf("Generating Keys...\n", new Object[0]);
            } else {
                System.out.print("\n");
                CuaimaCommand.PrintVersion();
                if (EncryptAlg == 0) {
                    System.out.print("CuaimaCrypt Blocks: " + String.valueOf(Blocks) + "\n");
                }
                System.out.print("Generating Keys...\n");
            }
            start_time = System.nanoTime();
        }
        try {
            switch (EncryptAlg) {
                case 0: {
                    Crypto = new CuaimaText(Clave, Blocks);
                    break;
                }
                case 1: {
                    Crypto = new AESText(Clave);
                    break;
                }
                default: {
                    Crypto = new CuaimaText(Clave, Blocks);
                    break;
                }
            }
        }
        catch (UtilsException ex) {
            if (Log != null) {
                Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
            } else {
                Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
            return 3;
        }
        if (FVerbose) {
            end_time = System.nanoTime();
            difference = (double)(end_time - start_time) / 1.0E9;
            if (Consola != null) {
                Consola.printf("Keys Generation Time: " + Double.toString(difference) + " sec \n", new Object[0]);
            } else {
                System.out.print("Keys Generation Time: " + Double.toString(difference) + " sec \n");
            }
        }
        if (FVerbose) {
            if (Consola != null) {
                Consola.printf("\nHow to use Console Mode\n", new Object[0]);
                Consola.printf("- Introduce <empty line> to encript\n", new Object[0]);
                Consola.printf("- The encrypted content IS AUTOMATICALLY COPIED to ClipBoard\n\n", new Object[0]);
                Consola.printf("- To dencrypt introduce the encrypted text delimited by:\n\n", new Object[0]);
                Consola.printf("----- Begin Encrypted Text -----\n", new Object[0]);
                Consola.printf(" < Encrypted Text >\n", new Object[0]);
                Consola.printf("----- End Encrypted Text -----\n\n", new Object[0]);
                Consola.printf("- To Paste from ClipBoard use ^V ALONE on one line\n", new Object[0]);
                Consola.printf("- To Exit use ESC char or ^[ ALONE on one line\n\n", new Object[0]);
            } else {
                System.out.print("\nHow to use Console Mode\n");
                System.out.print("- Introduce <empty line> to encript\n");
                System.out.print("- The encrypted content IS AUTOMATICALLY COPIED to ClipBoard\n\n");
                System.out.print("- To dencrypt introduce the encrypted text delimited by:\n\n");
                System.out.print("----- Begin Encrypted Text -----\n");
                System.out.print(" < Encrypted Text >\n");
                System.out.print("----- End Encrypted Text -----\n\n");
                System.out.print("- To Paste from ClipBoard use ^V ALONE on one line\n");
                System.out.print("- To Exit use ESC char or ^[ ALONE on one line\n\n");
            }
        }
        Linea = null;
        StringBuffer Buffer = new StringBuffer(0x3200000);
        boolean Salir = false;
        boolean Dencrypt = false;
        while (!Salir) {
            if (Consola != null) {
                char[] TempChars;
                Linea = FVerbose ? Consola.readLine() : ((TempChars = Consola.readPassword()) != null ? new String(TempChars) : null);
            } else {
                try {
                    Linea = Reader2.readLine();
                }
                catch (IOException ex) {
                    if (Log != null) {
                        Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
                    } else {
                        Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                    }
                    return 1;
                }
            }
            if (Linea == null) continue;
            if (!Linea.equals("\u001b")) {
                if (Linea.equals("\u0016")) {
                    Linea = ClipBoard.getClipboardContents();
                    if (FVerbose) {
                        if (Consola != null) {
                            Consola.printf(Linea, new Object[0]);
                        } else {
                            System.out.print(Linea);
                        }
                    }
                }
                Linea = Linea + "\n";
                Buffer.append(Linea);
                int BeginEncrypted = Buffer.indexOf("----- Begin Encrypted Text -----");
                if (BeginEncrypted != -1 && (EndEncrypted = Buffer.indexOf("----- End Encrypted Text -----", BeginEncrypted)) != -1) {
                    Linea = Buffer.substring(BeginEncrypted += "----- Begin Encrypted Text -----".length(), EndEncrypted);
                    for (i = 0; i < Buffer.length(); ++i) {
                        Buffer.setCharAt(i, '\u0000');
                    }
                    Buffer.setLength(0);
                    Dencrypt = true;
                }
                if (!Dencrypt && Linea.equals("\n")) {
                    Linea = Buffer.toString();
                    start_time = System.nanoTime();
                    try {
                        Linea = Crypto.Codec(Linea, 3);
                    }
                    catch (UtilsException ex) {
                        if (Log != null) {
                            Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
                        } else {
                            Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                        }
                        return 3;
                    }
                    end_time = System.nanoTime();
                    difference = (double)(end_time - start_time) / 1.0E9;
                    Buffer.setLength(0);
                    Buffer.append("----- Begin Encrypted Text -----\n");
                    Buffer.append(Linea + "\n");
                    Linea = "";
                    Buffer.append("----- End Encrypted Text -----\n");
                    if (Consola != null) {
                        Consola.printf(Buffer.toString(), new Object[0]);
                        if (FVerbose) {
                            Consola.printf("\nEncryption Time: " + Double.toString(difference) + " sec \n\n", new Object[0]);
                        }
                    } else {
                        System.out.print(Buffer.toString());
                        System.out.print("\nEncryption Time: " + Double.toString(difference) + " sec \n\n");
                    }
                    ClipBoard.setClipboardContents(Buffer.toString());
                    for (i = 0; i < Buffer.length(); ++i) {
                        Buffer.setCharAt(i, '\u0000');
                    }
                    Buffer.setLength(0);
                    continue;
                }
                if (!Dencrypt) continue;
                start_time = System.nanoTime();
                try {
                    Linea = Crypto.Decodec(Linea);
                }
                catch (UtilsException ex) {
                    if (Log != null) {
                        Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
                    } else {
                        Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                    }
                    return 3;
                }
                end_time = System.nanoTime();
                difference = (double)(end_time - start_time) / 1.0E9;
                Buffer.setLength(0);
                Buffer.append("\n");
                Buffer.append(Linea);
                Linea = "";
                if (Consola != null) {
                    Consola.printf(Buffer.toString(), new Object[0]);
                    if (FVerbose) {
                        Consola.printf("\nDencryption Time: " + Double.toString(difference) + " sec \n\n", new Object[0]);
                    }
                } else {
                    System.out.print(Buffer.toString());
                    System.out.print("\nDencryption Time: " + Double.toString(difference) + " sec \n\n");
                }
                for (i = 0; i < Buffer.length(); ++i) {
                    Buffer.setCharAt(i, '\u0000');
                }
                Buffer.setLength(0);
                Dencrypt = false;
                continue;
            }
            Salir = true;
        }
        ProgressBar TR = new ProgressBar();
        if (Consola != null) {
            if (FVerbose) {
                Consola.printf("Wiping Buffer\n", new Object[0]);
            }
        } else {
            System.out.print("Wiping Buffer\n");
        }
        Buffer.setLength(Buffer.capacity());
        EndEncrypted = -1;
        for (i = 0; i < Buffer.length(); ++i) {
            Buffer.setCharAt(i, '\u0000');
            if (!FVerbose || (Linea = TR.PlotProgressBar((int)(100.0f * ((float)i / (float)Buffer.length())))).equals("")) continue;
            System.out.print(Linea);
        }
        if (Consola != null) {
            if (FVerbose) {
                Consola.printf("\nBuffer Wiped\n", new Object[0]);
            }
        } else {
            System.out.print("\nBuffer Wiped\n");
        }
        if (Consola != null) {
            if (FVerbose) {
                Consola.printf("Wiping ClipBoard\n", new Object[0]);
            }
        } else {
            System.out.print("Wiping ClipBoard\n");
        }
        ClipBoard.setClipboardContents(Buffer.toString());
        ClipBoard.setClipboardContents("");
        if (Consola != null) {
            if (FVerbose) {
                Consola.printf("ClipBoard Wiped\n", new Object[0]);
            }
        } else {
            System.out.print("ClipBoard Wiped\n");
        }
        Buffer.setLength(0);
        if (Consola != null) {
            Consola.flush();
        } else {
            try {
                Reader2.close();
            }
            catch (IOException ex) {
                if (Log != null) {
                    Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
                } else {
                    Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
                }
                return 1;
            }
        }
        return 0;
    }

    private static String ProcessText(boolean FCodec, String Texto, String Clave, boolean FVerbose, int EncryptAlg, int Blocks) {
        String Salida = null;
        CryptoText Crypto = null;
        if (EncryptAlg != 2) {
            String Message;
            if (Clave.length() < 1) {
                Message = "ERROR: Password MUST have at least ONE character";
                if (Log != null) {
                    Log.LogMessage(2, 128, CuaimaCommand.class.getName(), Message);
                } else {
                    Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, Message);
                }
                System.exit(3);
            }
            if (Texto != null) {
                if (FVerbose) {
                    System.out.print("\n");
                    CuaimaCommand.PrintVersion();
                    System.out.print("Generating Keys...\n");
                }
                long start_time = System.nanoTime();
                try {
                    switch (EncryptAlg) {
                        case 0: {
                            Crypto = new CuaimaText(Clave, Blocks);
                            break;
                        }
                        case 1: {
                            Crypto = new AESText(Clave);
                            break;
                        }
                        default: {
                            Crypto = new CuaimaText(Clave, Blocks);
                            break;
                        }
                    }
                }
                catch (UtilsException ex) {
                    if (Log != null) {
                        Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
                    } else {
                        Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                    }
                    System.exit(3);
                }
                if (Crypto != null) {
                    if (FVerbose && EncryptAlg == 0) {
                        Message = "CuaimaCrypt Blocks: " + String.valueOf(Blocks);
                        System.out.println(Message);
                    }
                    try {
                        Salida = FCodec ? Crypto.Codec(Texto, 2) : Crypto.Decodec(Texto);
                    }
                    catch (UtilsException ex) {
                        if (Log != null) {
                            Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage());
                        } else {
                            Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                        }
                        System.exit(3);
                    }
                    if (FVerbose) {
                        if (FCodec) {
                            System.out.println("----- Begin Encrypted Text -----");
                        } else {
                            System.out.println("----- Begin Dencrypted Text -----");
                        }
                    }
                    System.out.println(Salida);
                    if (FVerbose) {
                        if (FCodec) {
                            System.out.println("----- End Encrypted Text -----");
                        } else {
                            System.out.println("----- End Dencrypted Text -----");
                        }
                        long end_time = System.nanoTime();
                        double difference = (double)(end_time - start_time) / 1.0E9;
                        if (FCodec) {
                            System.out.print("\nEncryption Time: " + Double.toString(difference) + " sec \n");
                        } else {
                            System.out.print("\nDencryption Time: " + Double.toString(difference) + " sec \n");
                        }
                    }
                }
            } else {
                if (Log != null) {
                    Log.LogMessage(2, 128, CuaimaCommand.class.getName(), "NO Text on Command Line Text (De)Encryption");
                } else {
                    Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, "NO Text on Command Line Text (De)Encryption");
                }
                System.exit(3);
            }
        } else {
            if (FVerbose) {
                System.out.println("WARNING: Obfuscation mode IS NOT AN ENCRYPTION ALGORITHM AND IT IS NOT SECURE!!!\n");
            }
            long start_time = System.nanoTime();
            if (FCodec) {
                try {
                    Salida = ValhalaObfuscator.Obfuscate((String)Texto);
                }
                catch (UtilsException ex) {
                    if (Log != null) {
                        Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getMessage());
                    } else {
                        Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getMessage());
                    }
                    System.exit(3);
                }
            } else {
                try {
                    Salida = ValhalaObfuscator.Deobfuscate((String)Texto);
                }
                catch (UtilsException ex) {
                    if (Log != null) {
                        Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getMessage());
                    } else {
                        Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getMessage());
                    }
                    System.exit(3);
                }
            }
            if (FVerbose) {
                if (FCodec) {
                    System.out.println("----- Begin Obfuscated Text -----");
                } else {
                    System.out.println("----- Begin Deobfuscated Text -----");
                }
            }
            System.out.println(Salida);
            if (FVerbose) {
                if (FCodec) {
                    System.out.println("----- End Obfuscated Text -----");
                } else {
                    System.out.println("----- End Deobfuscated Text -----");
                }
                long end_time = System.nanoTime();
                double difference = (double)(end_time - start_time) / 1.0E9;
                if (FCodec) {
                    System.out.print("\nObfuscation Time: " + Double.toString(difference) + " sec \n");
                } else {
                    System.out.print("\nObfuscation Time: " + Double.toString(difference) + " sec \n");
                }
            }
        }
        return Salida;
    }

    public static void main(String[] args) {
        CommandLine Args = null;
        boolean FCodec = true;
        FileManager InputFile = null;
        FileManager OutputFile = null;
        String Clave = null;
        boolean FVerbose = true;
        int EncryptAlg = 0;
        int Blocks = 16;
        boolean isFile = true;
        String Texto = null;
        if (!EnvironmentUtils.CheckJavaVersion(JRE_VERSION)) {
            System.err.println("ERROR: JRE version 1.7.0_40 or more required");
            System.exit(5);
        }
        Log = SimpleLogger.getInstance();
        Option Encrypt = new Option("e", "encrypt", false, "Encrypt the file");
        Option Dencrypt = new Option("d", "dencrypt", false, "Dencrypt the file");
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"passwd");
        OptionBuilder.withDescription((String)"Password to process the file. MUST have 1 or more charectes ");
        Option Password = OptionBuilder.create((String)"p");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.withDescription((String)"File to process");
        Option File2 = OptionBuilder.create((String)"f");
        OptionBuilder.withArgName((String)"text");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withLongOpt((String)"text");
        OptionBuilder.withDescription((String)"Text to process, if no <text> is provided the standard input is readed");
        Option Text = OptionBuilder.create((String)"t");
        Option Help = new Option("h", "help", false, "print this message and exit");
        Option Version = new Option("version", "print the version information and exit");
        Option Quiet = new Option("q", "quiet", false, "No show any information in the terminal");
        Option Verbose = new Option("v", "verbose", false, "Show file information and progress in the terminal (Default)");
        Option OCuaima = new Option("cuaima", "Use CuaimaCrypt to process the input (Default)");
        Option Oaes = new Option("aes", "Use AES to process the input");
        Option Oobfc = new Option("obfc", "Use obfuscation algorith to process the input");
        OptionBuilder.withArgName((String)"blocks");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"blocks");
        OptionBuilder.withDescription((String)"Number de Blocks to be used by CuaimaCrypt, Must be more than 1");
        Option NBlocks = OptionBuilder.create((String)"b");
        Options CLIoptions = new Options();
        CLIoptions.addOption(Encrypt);
        CLIoptions.addOption(Dencrypt);
        CLIoptions.addOption(Password);
        CLIoptions.addOption(File2);
        CLIoptions.addOption(Text);
        CLIoptions.addOption(Help);
        CLIoptions.addOption(Version);
        CLIoptions.addOption(Quiet);
        CLIoptions.addOption(Verbose);
        CLIoptions.addOption(OCuaima);
        CLIoptions.addOption(Oaes);
        CLIoptions.addOption(Oobfc);
        CLIoptions.addOption(NBlocks);
        BasicParser Parser = new BasicParser();
        try {
            Args = Parser.parse(CLIoptions, args);
            if (Args.hasOption("help")) {
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(0);
            }
            if (Args.hasOption("version")) {
                CuaimaCommand.PrintVersion();
                CuaimaCommand.PrintCopyright();
                System.exit(0);
            }
            if (Args.hasOption("cuaima") && !Args.hasOption("aes") && !Args.hasOption("obfc")) {
                EncryptAlg = 0;
            } else if (Args.hasOption("aes") && !Args.hasOption("cuaima") && !Args.hasOption("obfc")) {
                EncryptAlg = 1;
            } else if (Args.hasOption("obfc") && !Args.hasOption("cuaima") && !Args.hasOption("aes")) {
                EncryptAlg = 2;
            } else if (Args.hasOption("cuaima") && Args.hasOption("aes") && Args.hasOption("obfc")) {
                System.err.println("ERROR: ONLY ONE option -cuaima or -aes or -obfc MUST be used!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else if (Args.hasOption("cuaima") && Args.hasOption("aes")) {
                System.err.println("ERROR: ONLY ONE option -cuaima or -aes MUST be used!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else if (Args.hasOption("cuaima") && Args.hasOption("obfc")) {
                System.err.println("ERROR: ONLY ONE option -cuaima or -obfc MUST be used!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else if (Args.hasOption("obfc") && Args.hasOption("aes")) {
                System.err.println("ERROR: ONLY ONE option -obfc or -aes MUST be used!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else {
                EncryptAlg = 0;
            }
            if (Args.hasOption("blocks")) {
                if (EncryptAlg == 0) {
                    Clave = Args.getOptionValue("blocks");
                    try {
                        Blocks = Integer.valueOf(Clave);
                        if (Blocks < 2) {
                            System.err.println("ERROR: The option --blocks MUST be greater than 1");
                            CuaimaCommand.PrintHelp(CLIoptions);
                            System.exit(1);
                        }
                    }
                    catch (NumberFormatException ex) {
                        if (Log != null) {
                            Log.LogMessage(2, 128, CuaimaCommand.class.getName(), ex.getLocalizedMessage() + " MUST be an Integer");
                        } else {
                            Logger.getLogger(CuaimaCommand.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage() + " MUST be an Integer", ex);
                        }
                        System.exit(2);
                    }
                } else {
                    System.err.println("ERROR: The option --blocks MUST be used ony with CuaimaCrypt Encryption System");
                    CuaimaCommand.PrintHelp(CLIoptions);
                    System.exit(1);
                }
            } else {
                Blocks = 16;
            }
            if (Args.hasOption("verbose") && !Args.hasOption("quiet")) {
                FVerbose = true;
            } else if (Args.hasOption("quiet") && !Args.hasOption("verbose")) {
                FVerbose = false;
            } else if (Args.hasOption("verbose") && Args.hasOption("quiet")) {
                System.err.println("ERROR: ONLY ONE option -verbose or -quiet MUST be used!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else {
                FVerbose = true;
            }
            if (Args.hasOption("text") && Args.getOptionValue("text") == null && !Args.hasOption("file")) {
                if (!Args.hasOption("obfc")) {
                    if (!Args.hasOption("encrypt") && !Args.hasOption("dencrypt")) {
                        if (Args.hasOption("passwd")) {
                            Clave = Args.getOptionValue("passwd");
                        }
                        if ((Blocks = CuaimaCommand.ConsoleMode(Clave, FVerbose, EncryptAlg, Blocks)) == 0) {
                            System.exit(0);
                        }
                        System.exit(Blocks);
                    } else {
                        System.err.println("ERROR: option --text (noArg) don't need --encrypt or --dencrypt options!!!\n");
                        CuaimaCommand.PrintHelp(CLIoptions);
                        System.exit(1);
                    }
                } else {
                    System.err.println("ERROR: option -obfc not available in console mode, -cuaima or -aes MUST be used!!!\n");
                    CuaimaCommand.PrintHelp(CLIoptions);
                    System.exit(1);
                }
            } else if (Args.hasOption("text") && Args.hasOption("file")) {
                System.err.println("ERROR: ONLY ONE option -file or -text MUST be used!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            }
            if (Args.hasOption("passwd") && !Args.hasOption("obfc")) {
                Clave = Args.getOptionValue("passwd");
            } else if (!Args.hasOption("passwd") && Args.hasOption("obfc") && Args.hasOption("text")) {
                Clave = null;
            } else if (Args.hasOption("passwd") && Args.hasOption("obfc") && Args.hasOption("text")) {
                System.err.println("ERROR: The option --passwd is NOT NEEDED to Obfuscate a text\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else if (Args.hasOption("passwd") && Args.hasOption("obfc") && Args.hasOption("file")) {
                System.err.println("ERROR: The option -obfc CAN'T BE USED with -file to Obfuscate a file\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else {
                System.err.println("ERROR: The option --passwd MUST be used to establish the password used to\n process the file or text!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            }
            if (Args.hasOption("encrypt") && !Args.hasOption("dencrypt")) {
                FCodec = true;
            } else if (Args.hasOption("dencrypt") && !Args.hasOption("encrypt")) {
                FCodec = false;
            } else {
                if (Args.hasOption("encrypt") && Args.hasOption("dencrypt")) {
                    System.err.println("ERROR: ONLY ONE option --encrypt or --dencrypt MUST be used!!!\n");
                } else {
                    System.err.println("ERROR: ONE option --encrypt or --dencrypt MUST be used!!!\n");
                }
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            }
            if (Args.hasOption("file") && !Args.hasOption("text")) {
                if (!Args.hasOption("obfc")) {
                    InputFile = new FileManager(Args.getOptionValue("file"));
                    if (InputFile.getFilePath() == null) {
                        InputFile = new FileManager(System.getProperty("user.dir") + InputFile.getSeparador() + Args.getOptionValue("file"));
                    }
                    if (!InputFile.Exists()) {
                        System.err.println("ERROR: The file " + Args.getOptionValue("file") + " NOT found");
                        System.exit(2);
                    }
                    isFile = true;
                } else {
                    System.err.println("ERROR: option -obfc not available to precess files, -cuaima or -aes MUST be used!!!\n");
                    CuaimaCommand.PrintHelp(CLIoptions);
                    System.exit(1);
                }
            } else if (Args.hasOption("text") && !Args.hasOption("file")) {
                Texto = Args.getOptionValue("text");
                isFile = false;
            } else if (Args.hasOption("text") && Args.hasOption("file")) {
                System.err.println("ERROR: ONLY ONE option -file or -text MUST be used!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else if (Args.hasOption("obfc") && Args.hasOption("file")) {
                System.err.println("ERROR: Option -file CAN'T BE USED with -obfc!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            } else {
                System.err.println("ERROR: The option -file or -text MUST be used to especify the file to be processed!!!\n");
                CuaimaCommand.PrintHelp(CLIoptions);
                System.exit(1);
            }
        }
        catch (ParseException exp) {
            System.err.println("ERROR: " + exp.getMessage() + "\n");
            CuaimaCommand.PrintHelp(CLIoptions);
            System.exit(1);
        }
        if (isFile) {
            OutputFile = CuaimaCommand.ProcessFile(FCodec, InputFile, Clave, FVerbose, EncryptAlg, Blocks);
        } else {
            Texto = CuaimaCommand.ProcessText(FCodec, Texto, Clave, FVerbose, EncryptAlg, Blocks);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

