/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.crypto.digest;

import com.valhalanetworks.crypto.digest.IMessageDigest;
import com.valhalanetworks.utils.converters.Converter;
import java.nio.charset.StandardCharsets;

public abstract class BaseHash
implements IMessageDigest {
    protected String name;
    protected int hashSize;
    protected int blockSize;
    protected long count;
    protected byte[] buffer;

    protected BaseHash(String name, int hashSize, int blockSize) {
        this.name = name;
        this.hashSize = hashSize;
        this.blockSize = blockSize;
        this.buffer = new byte[blockSize];
        this.resetContext();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int hashSize() {
        return this.hashSize;
    }

    @Override
    public int blockSize() {
        return this.blockSize;
    }

    @Override
    public void update(byte b) {
        int i = (int)(this.count % (long)this.blockSize);
        ++this.count;
        this.buffer[i] = b;
        if (i == this.blockSize - 1) {
            this.transform(this.buffer, 0);
        }
    }

    @Override
    public void update(byte[] b, int offset, int len) {
        int n = (int)(this.count % (long)this.blockSize);
        this.count += (long)len;
        int partLen = this.blockSize - n;
        int i = 0;
        if (len >= partLen) {
            System.arraycopy(b, offset, this.buffer, n, partLen);
            this.transform(this.buffer, 0);
            i = partLen;
            while (i + this.blockSize - 1 < len) {
                this.transform(b, offset + i);
                i += this.blockSize;
            }
            n = 0;
        }
        if (i < len) {
            System.arraycopy(b, offset + i, this.buffer, n, len - i);
        }
    }

    @Override
    public byte[] digest() {
        byte[] tail = this.padBuffer();
        this.update(tail, 0, tail.length);
        byte[] result = this.getResult();
        this.reset();
        return result;
    }

    @Override
    public void reset() {
        this.count = 0L;
        int i = 0;
        while (i < this.blockSize) {
            this.buffer[i++] = 0;
        }
        this.resetContext();
    }

    @Override
    public byte[] Hash(byte[] Input) {
        this.reset();
        this.update(Input, 0, Input.length);
        return this.digest();
    }

    @Override
    public byte[] Hash(String Message) {
        this.reset();
        byte[] Intermedio = Message.getBytes(StandardCharsets.UTF_16);
        this.update(Intermedio, 0, Intermedio.length);
        return this.digest();
    }

    @Override
    public byte[] Hash(long[] Input) {
        this.reset();
        byte[] Entrada = Converter.long2byte(Input);
        this.update(Entrada, 0, Entrada.length);
        return this.digest();
    }

    @Override
    public byte[] Hash(int[] Input) {
        this.reset();
        byte[] Entrada = Converter.int2byte(Input);
        this.update(Entrada, 0, Entrada.length);
        return this.digest();
    }

    @Override
    public abstract Object clone();

    @Override
    public abstract boolean selfTest();

    protected abstract byte[] padBuffer();

    protected abstract byte[] getResult();

    protected abstract void resetContext();

    protected abstract void transform(byte[] var1, int var2);
}

