/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.array;

import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Unimatrix {
    private static final int INTLENGMASK = Integer.MAX_VALUE;
    private static final long LONGLENGMASK = Long.MAX_VALUE;
    public static final int ERROROUTOFMEMORY = 1;
    public static final int ERRORGRIDOUTOFRANGE = 2;
    public static final int ERRORUNIMATRIXISNULL = 4;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    @GuardedBy(value="rwl")
    private Object[][] UniJunctions = null;
    @GuardedBy(value="rwl")
    private long UniMatrixCapacity = 0L;

    public Unimatrix(long Capacity) {
        try {
            this.setCapacity(Capacity);
        }
        catch (UtilsException ex) {
            Logger.getLogger(Unimatrix.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public final long getCapacity() {
        long Capacity = 0L;
        this.rwl.readLock().lock();
        try {
            Capacity = this.UniMatrixCapacity;
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return Capacity;
    }

    private long CalcCapacity() {
        long Capacity = 0L;
        if (this.UniJunctions != null) {
            int NumUniJunctions = this.UniJunctions.length;
            for (int PosU = 0; PosU < NumUniJunctions; ++PosU) {
                Capacity += (long)this.UniJunctions[PosU].length;
            }
        }
        return Capacity;
    }

    public final void setCapacity(long Capacity) throws UtilsException {
        Object[][] OrgUniJunctions = null;
        int NumUniJunctions = (int)((Capacity &= Long.MAX_VALUE) / Integer.MAX_VALUE);
        if ((int)(Capacity % Integer.MAX_VALUE) > 0) {
            ++NumUniJunctions;
        }
        this.rwl.writeLock().lock();
        try {
            if (this.UniJunctions == null) {
                int PosG;
                this.UniJunctions = new Object[NumUniJunctions][];
                int Temp = NumUniJunctions - 1;
                for (int PosU = 0; PosU < Temp; ++PosU) {
                    this.UniJunctions[PosU] = new Object[Integer.MAX_VALUE];
                    for (PosG = 0; PosG < Integer.MAX_VALUE; ++PosG) {
                        this.UniJunctions[PosU][PosG] = null;
                    }
                }
                int NumGrids = (int)(Capacity % Integer.MAX_VALUE);
                if (NumGrids == 0) {
                    NumGrids = Integer.MAX_VALUE;
                }
                this.UniJunctions[PosU] = new Object[NumGrids];
                for (PosG = 0; PosG < NumGrids; ++PosG) {
                    this.UniJunctions[PosU][PosG] = null;
                }
            } else {
                int PosU;
                OrgUniJunctions = this.UniJunctions;
                this.UniJunctions = new Object[NumUniJunctions][];
                int Temp = Math.min(NumUniJunctions, OrgUniJunctions.length);
                --Temp;
                for (PosU = 0; PosU < Temp; ++PosU) {
                    this.UniJunctions[PosU] = OrgUniJunctions[PosU];
                }
                if (NumUniJunctions <= OrgUniJunctions.length) {
                    int PosG;
                    int NumGrids = (int)(Capacity % Integer.MAX_VALUE);
                    if (NumGrids == 0) {
                        NumGrids = Integer.MAX_VALUE;
                    }
                    this.UniJunctions[PosU] = new Object[NumGrids];
                    Temp = Math.min(NumGrids, OrgUniJunctions[PosU].length);
                    for (PosG = 0; PosG < Temp; ++PosG) {
                        this.UniJunctions[PosU][PosG] = OrgUniJunctions[PosU][PosG];
                    }
                    while (PosG < NumGrids) {
                        this.UniJunctions[PosU][PosG] = null;
                        ++PosG;
                    }
                } else {
                    int PosG;
                    this.UniJunctions[PosU] = new Object[Integer.MAX_VALUE];
                    Temp = OrgUniJunctions[PosU].length;
                    for (PosG = 0; PosG < Temp; ++PosG) {
                        this.UniJunctions[PosU][PosG] = OrgUniJunctions[PosU][PosG];
                    }
                    while (PosG < Integer.MAX_VALUE) {
                        this.UniJunctions[PosU][PosG] = null;
                        ++PosG;
                    }
                    ++PosU;
                    while (PosU < NumUniJunctions - 1) {
                        this.UniJunctions[PosU] = new Object[Integer.MAX_VALUE];
                        for (PosG = 0; PosG < Integer.MAX_VALUE; ++PosG) {
                            this.UniJunctions[PosU][PosG] = null;
                        }
                        ++PosU;
                    }
                    int NumGrids = (int)(Capacity % Integer.MAX_VALUE);
                    if (NumGrids == 0) {
                        NumGrids = Integer.MAX_VALUE;
                    }
                    this.UniJunctions[PosU] = new Object[NumGrids];
                    for (PosG = 0; PosG < NumGrids; ++PosG) {
                        this.UniJunctions[PosU][PosG] = null;
                    }
                }
            }
            this.UniMatrixCapacity = this.CalcCapacity();
        }
        catch (OutOfMemoryError e) {
            MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage HeapUsage = memoryBean.getHeapMemoryUsage();
            MemoryUsage NoHeapUsage = memoryBean.getNonHeapMemoryUsage();
            long maxMemory = NoHeapUsage.getMax() / 0x100000L;
            long usedMemory = NoHeapUsage.getUsed() / 0x100000L;
            long HmaxMemory = HeapUsage.getMax() / 0x100000L;
            long HusedMemory = HeapUsage.getUsed() / 0x100000L;
            if (OrgUniJunctions != null) {
                this.UniJunctions = OrgUniJunctions;
                this.UniMatrixCapacity = this.CalcCapacity();
            } else {
                this.UniJunctions = null;
                this.UniMatrixCapacity = 0L;
            }
            throw new UtilsException("ERROR: UniMatrix Out of Memory\n Heap Memory: (" + Long.toString(HusedMemory) + "MB)/(" + Long.toString(HmaxMemory) + "MB)\n No Heap Memory (" + Long.toString(usedMemory) + "MB)/(" + Long.toString(maxMemory) + "MB)", 1);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElement(long Grid, Object Element) throws UtilsException {
        block7: {
            if (this.UniJunctions != null) {
                int PosU = (int)((Grid &= Long.MAX_VALUE) / Integer.MAX_VALUE);
                int PosG = (int)(Grid % Integer.MAX_VALUE);
                this.rwl.writeLock().lock();
                try {
                    if (PosU < this.UniJunctions.length) {
                        if (this.UniJunctions[PosU] != null) {
                            if (PosG < this.UniJunctions[PosU].length) {
                                this.UniJunctions[PosU][PosG] = Element;
                                break block7;
                            }
                            throw new UtilsException("ERROR: Grid " + Long.toString(Grid) + " out of range at UniJunction " + Integer.toString(PosU) + " in the Unimatrix", 2);
                        }
                        throw new UtilsException("ERROR: UniJunction " + Integer.toString(PosU) + " is NULL in the Unimatrix", 4);
                    }
                    throw new UtilsException("ERROR: Grid " + Long.toString(Grid) + " out of range at UniJunctions level in the Unimatrix", 2);
                }
                finally {
                    this.rwl.writeLock().unlock();
                }
            }
            throw new UtilsException("ERROR: UniJunctions is NULL in the Unimatrix", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getElement(long Grid) throws UtilsException {
        Object Element;
        block7: {
            Element = null;
            if (this.UniJunctions != null) {
                int PosU = (int)((Grid &= Long.MAX_VALUE) / Integer.MAX_VALUE);
                int PosG = (int)(Grid % Integer.MAX_VALUE);
                this.rwl.writeLock().lock();
                try {
                    if (PosU < this.UniJunctions.length) {
                        if (this.UniJunctions[PosU] != null) {
                            if (PosG < this.UniJunctions[PosU].length) {
                                Element = this.UniJunctions[PosU][PosG];
                                break block7;
                            }
                            throw new UtilsException("ERROR: Grid " + Long.toString(Grid) + " out of range at UniJunction " + Integer.toString(PosU) + " in the Unimatrix", 2);
                        }
                        throw new UtilsException("ERROR: UniJunction " + Integer.toString(PosU) + " is NULL in the Unimatrix", 4);
                    }
                    throw new UtilsException("ERROR: Grid " + Long.toString(Grid) + " out of range at UniJunctions level in the Unimatrix", 2);
                }
                finally {
                    this.rwl.writeLock().unlock();
                }
            }
            throw new UtilsException("ERROR: UniJunctions is NULL in the Unimatrix", 4);
        }
        return Element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long Defrag() throws UtilsException {
        PosU = 0;
        PosG = -1;
        if (this.UniJunctions != null) {
            this.rwl.writeLock().lock();
            try {
                NumUniJunctions = this.UniJunctions.length;
                SeekU = 0;
                SeekG = 0;
                SeekNumGrids = this.UniJunctions[SeekU].length;
                while (SeekU < NumUniJunctions && SeekG < SeekNumGrids && this.UniJunctions[SeekU][SeekG] != null) {
                    if (++SeekG != SeekNumGrids || ++SeekU >= NumUniJunctions) continue;
                    SeekNumGrids = this.UniJunctions[SeekU].length;
                    SeekG = 0;
                }
                if (SeekU >= NumUniJunctions || SeekG >= SeekNumGrids || this.UniJunctions[SeekU][SeekG] != null) ** GOTO lbl42
                PosU = SeekU;
                PosG = SeekG;
                PosNumGrids = this.UniJunctions[PosU].length;
                while (SeekU < NumUniJunctions) {
                    while (SeekU < NumUniJunctions && SeekG < SeekNumGrids && this.UniJunctions[SeekU][SeekG] == null) {
                        if (++SeekG != SeekNumGrids || ++SeekU >= NumUniJunctions) continue;
                        SeekNumGrids = this.UniJunctions[SeekU].length;
                        SeekG = 0;
                    }
                    if (SeekU >= NumUniJunctions) continue;
                    while (SeekU < NumUniJunctions && SeekG < SeekNumGrids && this.UniJunctions[SeekU][SeekG] != null) {
                        this.UniJunctions[PosU][PosG] = this.UniJunctions[SeekU][SeekG];
                        this.UniJunctions[SeekU][SeekG] = null;
                        if (++PosG == PosNumGrids && ++PosU < NumUniJunctions) {
                            PosNumGrids = this.UniJunctions[PosU].length;
                            PosG = 0;
                        }
                        if (++SeekG != SeekNumGrids || ++SeekU >= NumUniJunctions) continue;
                        SeekNumGrids = this.UniJunctions[SeekU].length;
                        SeekG = 0;
                    }
                }
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        } else {
            throw new UtilsException("ERROR: UniJunctions is NULL in the Unimatrix at Defragg", 4);
        }
lbl42:
        // 2 sources

        Local = PosU * 0x7FFFFFFF + PosG;
        return Local;
    }

    public void Trim() throws UtilsException {
        long NewSize = this.Defrag();
        if (NewSize == 0L) {
            NewSize = 1L;
        }
        if (NewSize > 0L) {
            this.setCapacity(NewSize);
        }
    }
}

