/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.communications.tcpip;

import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.communications.tcpip.TcpIpServerConnectionManager;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import java.io.IOException;
import java.net.ServerSocket;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpIpServer
implements Runnable {
    private final int Port;
    @GuardedBy(value="this")
    private TcpIpServerConnectionManager[] Conexiones;
    private Thread ConectionsWatcher = null;
    private TcpIPServerConnectionListener ConectionsListener = null;
    private boolean RunServer;
    private boolean ServerStopped;
    private int ErrorCode;
    private LoggerManager Bitacora;
    public static final int ERROR_CANTOPENPORT = 1;
    public static final int ERROR_IO = 2;
    public static final int ERROR_CANTCLOSEPORT = 3;
    public static final int ERROR_CANTCONNECTREQUEST = 4;
    public static final int ERROR_CANTSLEEPTHREAD = 5;

    public TcpIpServer(int Port) {
        this.Port = Port;
        this.Conexiones = null;
        this.RunServer = false;
        this.Bitacora = null;
    }

    public void setBitacora(LoggerManager Bitacora) {
        this.Bitacora = Bitacora;
    }

    public int getPort() {
        return this.Port;
    }

    public void start() throws UtilsException {
        int Priority;
        this.ConectionsWatcher = new Thread(this);
        this.ConectionsWatcher.setName("TCP/IP Connection Watcher started " + new Timestamp(System.currentTimeMillis()).toString());
        boolean ChangeThead = true;
        try {
            this.ConectionsWatcher.checkAccess();
        }
        catch (SecurityException ex) {
            ChangeThead = false;
        }
        if (ChangeThead) {
            Priority = this.ConectionsWatcher.getPriority() - 3;
            if (Priority < 1) {
                Priority = 1;
            }
            this.ConectionsWatcher.setPriority(Priority);
        }
        this.ConectionsListener = new TcpIPServerConnectionListener(this.Port, this.Conexiones, this);
        ChangeThead = true;
        try {
            this.ConectionsListener.checkAccess();
        }
        catch (SecurityException ex) {
            ChangeThead = false;
        }
        if (ChangeThead) {
            Priority = this.ConectionsListener.getPriority() - 1;
            if (Priority < 1) {
                Priority = 1;
            }
            this.ConectionsListener.setPriority(Priority);
        }
        this.RunServer = true;
        this.ConectionsWatcher.start();
        this.ConectionsListener.start();
        this.ErrorCode = this.ConectionsListener.GetErrorCode();
        if (this.ErrorCode != 0) {
            throw new UtilsException("ERROR: Could not open listener on port: " + this.Port, this.ErrorCode);
        }
    }

    public void Stop() throws UtilsException {
        boolean Error2 = false;
        this.RunServer = false;
        while (!this.ServerStopped) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new UtilsException("ERROR: Could not sleep the TCP/IP Server Thread", 5);
            }
        }
        this.ConectionsListener.Stop();
        this.ErrorCode = this.ConectionsListener.GetErrorCode();
        if (this.ErrorCode != 0) {
            Error2 = true;
        }
        this.ConectionsListener = null;
        this.Clean();
        this.ConectionsWatcher = null;
        if (Error2) {
            throw new UtilsException("ERROR: Could not close listen on port: " + this.Port, this.ErrorCode);
        }
    }

    public synchronized int getErrorCode() {
        int Salida = this.ErrorCode;
        this.ErrorCode = 0;
        return Salida;
    }

    public synchronized TcpIpServerConnectionManager[] getNewConnections() {
        TcpIpServerConnectionManager[] NewConexiones = null;
        if (this.Conexiones != null) {
            this.Conexiones = (TcpIpServerConnectionManager[])ArrayUtils.arrayTrim(this.Conexiones);
            int longitud = this.Conexiones.length;
            for (int i = 0; i < longitud; ++i) {
                if (!this.Conexiones[i].isNew()) continue;
                if (NewConexiones == null) {
                    NewConexiones = new TcpIpServerConnectionManager[]{this.Conexiones[i]};
                } else {
                    NewConexiones = (TcpIpServerConnectionManager[])ArrayUtils.resizeArray(NewConexiones, NewConexiones.length + 1);
                    NewConexiones[NewConexiones.length - 1] = this.Conexiones[i];
                }
                this.Conexiones[i].ClearNewFlag();
            }
        }
        return NewConexiones;
    }

    private synchronized void Clean() {
        if (this.Conexiones != null) {
            int longitud = this.Conexiones.length;
            for (int i = 0; i < longitud; ++i) {
                this.Conexiones[i].Stop();
                this.Conexiones[i] = null;
            }
            this.Conexiones = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.ServerStopped = false;
        MersenneTwisterPlus Aleatorio = new MersenneTwisterPlus();
        while (this.RunServer) {
            TcpIpServer tcpIpServer;
            if (this.ConectionsListener.ConnetionsChanged()) {
                tcpIpServer = this;
                synchronized (tcpIpServer) {
                    this.Conexiones = this.ConectionsListener.GetConnetions();
                    this.ErrorCode = this.ConectionsListener.GetErrorCode();
                }
            }
            tcpIpServer = this;
            synchronized (tcpIpServer) {
                if (this.Conexiones != null) {
                    int longitud = this.Conexiones.length;
                    for (int i = 0; i < longitud; ++i) {
                        if (this.Conexiones[i].isOpen()) continue;
                        this.Conexiones[i] = null;
                    }
                    this.Conexiones = (TcpIpServerConnectionManager[])ArrayUtils.arrayTrim(this.Conexiones);
                    this.ConectionsListener.SetConnections(this.Conexiones);
                }
            }
            try {
                Thread.sleep(100 + Math.abs(Aleatorio.nextInt()) % 900);
            }
            catch (InterruptedException ex) {
                if (this.Bitacora == null) {
                    Logger.getLogger(TcpIpServer.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                this.Bitacora.LogMessage(2, 64, TcpIpServer.class.getName(), "ERROR: Thread Sleeper Fail");
            }
        }
        this.ServerStopped = true;
    }

    private class TcpIPServerConnectionListener
    extends Thread {
        private final Object ConectionLock;
        private boolean Salir;
        @GuardedBy(value="ConectionLock")
        private TcpIpServerConnectionManager[] Conexiones;
        @GuardedBy(value="ConectionLock")
        private boolean ChangedConexiones;
        @GuardedBy(value="this")
        private ServerSocket ServerSocket;
        private int Port;
        @GuardedBy(value="this")
        private int ErrorCode;
        public static final int ERROR_CANTOPENPORT = 1;
        public static final int ERROR_IO = 2;
        public static final int ERROR_CANTCLOSEPORT = 3;
        public static final int ERROR_CANTCONNECTREQUEST = 4;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TcpIPServerConnectionListener(int Port, TcpIpServerConnectionManager[] Conexiones, Object Lock2) {
            super("TCP/IP Connection Listener started " + new Timestamp(System.currentTimeMillis()).toString());
            this.ServerSocket = null;
            this.ChangedConexiones = false;
            this.Conexiones = Conexiones;
            this.ConectionLock = Lock2;
            this.Port = Port;
            TcpIPServerConnectionListener tcpIPServerConnectionListener = this;
            synchronized (tcpIPServerConnectionListener) {
                this.ErrorCode = 0;
            }
        }

        @GuardedBy(value="this")
        public synchronized int GetErrorCode() {
            int Salida = this.ErrorCode;
            this.ErrorCode = 0;
            return Salida;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean ConnetionsChanged() {
            boolean Salida = false;
            Object object = this.ConectionLock;
            synchronized (object) {
                Salida = this.ChangedConexiones;
            }
            return Salida;
        }

        protected TcpIpServerConnectionManager[] GetConnetions() {
            TcpIpServerConnectionManager[] Salida = this.Conexiones;
            this.ChangedConexiones = false;
            return Salida;
        }

        protected void SetConnections(TcpIpServerConnectionManager[] Conexiones) {
            this.Conexiones = Conexiones;
            this.ChangedConexiones = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() {
            TcpIPServerConnectionListener tcpIPServerConnectionListener = this;
            synchronized (tcpIPServerConnectionListener) {
                this.Salir = false;
                try {
                    this.ServerSocket = new ServerSocket(this.Port);
                }
                catch (IOException e) {
                    this.Salir = true;
                    this.ErrorCode = 1;
                }
                finally {
                    super.start();
                }
            }
        }

        public synchronized void Stop() {
            this.Salir = true;
            try {
                this.ServerSocket.close();
            }
            catch (IOException ex) {
                this.ErrorCode = 3;
            }
            this.ServerSocket = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.Salir) {
                try {
                    TcpIpServerConnectionManager ConectionManager = new TcpIpServerConnectionManager(this.ServerSocket.accept());
                    if (ConectionManager == null) continue;
                    ConectionManager.setBitacora(TcpIpServer.this.Bitacora);
                    ConectionManager.start();
                    Object object = this.ConectionLock;
                    synchronized (object) {
                        int longitud;
                        if (this.Conexiones != null) {
                            longitud = this.Conexiones.length;
                            this.Conexiones = (TcpIpServerConnectionManager[])ArrayUtils.resizeArray(this.Conexiones, longitud + 1);
                        } else {
                            this.Conexiones = new TcpIpServerConnectionManager[1];
                            longitud = 0;
                        }
                        this.Conexiones[longitud] = ConectionManager;
                        this.ChangedConexiones = true;
                    }
                    ConectionManager = null;
                }
                catch (IOException ex) {
                    TcpIPServerConnectionListener tcpIPServerConnectionListener = this;
                    synchronized (tcpIPServerConnectionListener) {
                        this.ErrorCode = 4;
                    }
                }
            }
        }
    }
}

