/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.disruptor;

import com.valhalanetworks.utils.disruptor.AlertException;
import com.valhalanetworks.utils.disruptor.Sequence;
import com.valhalanetworks.utils.disruptor.SequenceBarrier;
import com.valhalanetworks.utils.disruptor.WaitStrategy;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence = cursorSequence.get();
        if (availableSequence < sequence) {
            this.lock.lock();
            try {
                while ((availableSequence = cursorSequence.get()) < sequence) {
                    barrier.checkAlert();
                    this.processorNotifyCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
        this.lock.lock();
        try {
            this.processorNotifyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

