/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.statistics;

import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.files.FileManager;
import java.nio.charset.Charset;

public class FastDistributionCalc {
    private double[] X;
    private long[] Distribution;
    private double Jump;
    public static final int ValueOutOfDistribution = 1;
    public static final int ValueNotInDistribution = 2;
    public static final int CreateFileError = 3;

    public FastDistributionCalc(double Min, double Max, int NumSegmens) {
        this.Jump = (Max - Min) / (double)NumSegmens;
        this.X = new double[NumSegmens + 1];
        this.Distribution = new long[NumSegmens + 1];
        this.X[0] = Min;
        this.Distribution[0] = 0L;
        for (int i = 1; i < NumSegmens + 1; ++i) {
            this.X[i] = this.X[i - 1] + this.Jump;
            this.Distribution[i] = 0L;
        }
    }

    public void AddToDistribution(double Value) throws UtilsException {
        if (Value >= this.X[0] && Value <= this.X[this.X.length - 1]) {
            int Low = 0;
            int Hight = this.X.length;
            boolean Encontrado = false;
            while (Low < Hight) {
                int Pibote = (Hight - Low) / 2 + Low;
                if (Value >= this.X[Pibote] && Value < this.X[Pibote] + this.Jump) {
                    int n = Pibote;
                    this.Distribution[n] = this.Distribution[n] + 1L;
                    Encontrado = true;
                    Low = Hight;
                    continue;
                }
                if (Value < this.X[Pibote]) {
                    Hight = Pibote;
                    continue;
                }
                Low = Pibote;
            }
            if (!Encontrado) {
                throw new UtilsException("ERROR: " + Double.toString(Value) + " NOT found in the Distribution Range", 2);
            }
        } else {
            throw new UtilsException("WARNING: " + Double.toString(Value) + " Out of Distribution Range", 1);
        }
    }

    public void SaveToFile(FileManager Archivo) throws UtilsException {
        int i;
        Charset charset = Charset.forName("UTF-16");
        Archivo.Open(1);
        long Max = 0L;
        for (i = 0; i < this.X.length; ++i) {
            if (this.Distribution[i] <= Max) continue;
            Max = this.Distribution[i];
        }
        for (i = 0; i < this.X.length; ++i) {
            String Salida = String.valueOf(this.X[i]) + "," + String.valueOf((double)this.Distribution[i] / (double)Max);
            Salida = Salida + "\n";
            Archivo.Write(Salida.getBytes(charset));
        }
        Archivo.Close();
    }

    public double[][] GetDistribution() {
        int i;
        double[][] Salida = new double[this.X.length][2];
        long Max = 0L;
        for (i = 0; i < this.X.length; ++i) {
            if (this.Distribution[i] <= Max) continue;
            Max = this.Distribution[i];
        }
        for (i = 0; i < this.X.length; ++i) {
            Salida[i][0] = this.X[i];
            Salida[i][1] = (double)this.Distribution[i] / (double)Max;
        }
        return Salida;
    }
}

