/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.security;

import com.valhalanetworks.crypto.digest.CRC32;
import com.valhalanetworks.utils.bits.BitsUtils;
import com.valhalanetworks.utils.converters.Base64;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class ValhalaObfuscator {
    public static final int ERROR_INPUT_NULL = -1;
    public static final int ERROR_INPUT_CRC32_MISMATCH = -2;
    public static final int ERROR_INPUT_NOT_OBFUSCATED = -3;

    public static final byte[] Obfuscate(byte[] Input) throws UtilsException {
        byte Rotated;
        int shift;
        int i;
        byte[] Output = null;
        if (Input != null) {
            MersenneTwisterPlus random = new MersenneTwisterPlus();
            CRC32 Verify = new CRC32();
            byte[] Check = Verify.Hash(Input);
            Output = new byte[Input.length + 5];
            for (i = 0; i < Input.length; ++i) {
                Output[i] = Input[i];
            }
            for (i = 0; i < Check.length; ++i) {
                Output[i + Input.length] = Check[i];
            }
            Output[Output.length - 1] = random.nextByte();
            for (i = 0; i < Output.length - 2; ++i) {
                shift = i % 8;
                Rotated = BitsUtils.ByteRightRotation((byte)Output[i + 1], (int)shift);
                Output[i] = (byte)(Output[i] ^ Rotated);
                Rotated = BitsUtils.ByteLeftRotation((byte)Output[Output.length - 1], (int)shift);
                Output[i] = (byte)(Output[i] ^ Rotated);
            }
        } else {
            throw new UtilsException("Input is NULL", -1);
        }
        shift = i % 8;
        Rotated = BitsUtils.ByteLeftRotation((byte)Output[Output.length - 1], (int)shift);
        Output[i] = (byte)(Output[i] ^ Rotated);
        shift = ++i % 8;
        Output[i] = BitsUtils.ByteLeftRotation((byte)Output[i], (int)shift);
        return Output;
    }

    public static final String Obfuscate(String Input) throws UtilsException {
        String Result = null;
        if (Input != null) {
            byte[] Binario = Input.getBytes(StandardCharsets.UTF_8);
            if ((Binario = ValhalaObfuscator.Obfuscate(Binario)) != null) {
                try {
                    Result = Base64.encodeBytes((byte[])Binario, (int)4);
                }
                catch (IOException ex) {
                    throw new UtilsException(ex.getMessage());
                }
            }
        } else {
            throw new UtilsException("Input is NULL", -1);
        }
        return Result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final byte[] Deobfuscate(byte[] Input) throws UtilsException {
        byte[] Output = null;
        if (Input == null) throw new UtilsException("Input is NULL", -1);
        if (Input.length <= 5) throw new UtilsException("Input is NOT RECOGNISED as obfuscated ", -3);
        CRC32 Verify = new CRC32();
        int i = Input.length - 1;
        int shift = i % 8;
        Input[i] = BitsUtils.ByteRightRotation((byte)Input[i], (int)shift);
        shift = --i % 8;
        byte Rotated = BitsUtils.ByteLeftRotation((byte)Input[Input.length - 1], (int)shift);
        Input[i] = (byte)(Input[i] ^ Rotated);
        --i;
        while (i >= 0) {
            shift = i % 8;
            Rotated = BitsUtils.ByteLeftRotation((byte)Input[Input.length - 1], (int)shift);
            Input[i] = (byte)(Input[i] ^ Rotated);
            Rotated = BitsUtils.ByteRightRotation((byte)Input[i + 1], (int)shift);
            Input[i] = (byte)(Input[i] ^ Rotated);
            --i;
        }
        Output = new byte[Input.length - 5];
        for (i = 0; i < Output.length; ++i) {
            Output[i] = Input[i];
        }
        byte[] calCheck = Verify.Hash(Output);
        for (i = Input.length - 5; i < Input.length - 1; ++i) {
            if (Input[i] == calCheck[i + 5 - Input.length]) continue;
            Output = null;
            throw new UtilsException("Input is NULL", -2);
        }
        return Output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String Deobfuscate(String Input) throws UtilsException {
        String Result = null;
        if (Input == null) throw new UtilsException("Input is NULL", -1);
        try {
            byte[] Binario = Base64.decode((String)Input, (int)4);
            Binario = ValhalaObfuscator.Deobfuscate(Binario);
            if (Binario == null) return Result;
            return new String(Binario, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new UtilsException(ex.getMessage());
        }
    }
}

