/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.security;

import com.valhalanetworks.crypto.cuaimacrypt.utils.CuaimaBinary;
import com.valhalanetworks.crypto.cuaimacrypt.utils.CuaimaFile;
import com.valhalanetworks.crypto.cuaimacrypt.utils.CuaimaText;
import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.converters.Base64;
import com.valhalanetworks.utils.converters.Converter;
import com.valhalanetworks.utils.environment.EnvironmentUtils;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.files.FileManager;
import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.vthreads.annotations.GuardedBy;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValhalaSecurity
implements Runnable {
    private static ValhalaSecurity instance = null;
    private final ReentrantLock binaryLock = new ReentrantLock();
    private final ReentrantLock textLock = new ReentrantLock();
    private final ReentrantLock fileLock = new ReentrantLock();
    private int NUMBLOCKS = 4;
    @GuardedBy(value="binaryLock")
    private CuaimaBinary cBinary = null;
    @GuardedBy(value="textLock")
    private CuaimaText cText = null;
    @GuardedBy(value="fileLock")
    private CuaimaFile cFile = null;
    private LoggerManager vLog;
    private String SALT;
    private String VHID;
    private String SALTFILENAME;
    private String SALTPATH;
    private Thread Hebra = null;
    @GuardedBy(value="this")
    private boolean CODECSOK = false;

    private ValhalaSecurity(String SALTPATH, LoggerManager pLog) {
        this.vLog = pLog;
        this.VHID = EnvironmentUtils.getValhalaHwID((LoggerManager)this.vLog);
        if (this.VHID == null) {
            this.VHID = EnvironmentUtils.getOS();
        }
        this.SALTFILENAME = "vsv.slt";
        if (SALTPATH == null) {
            SALTPATH = EnvironmentUtils.getPathToJarfileDir(this.getClass());
        }
        this.SALTPATH = SALTPATH;
        this.SALT = this.getSALT();
        this.SetupCodecs();
    }

    private void SetupCodecs() {
        this.Hebra = new Thread(this);
        this.Hebra.setPriority(10);
        this.Hebra.setName("ValhalaSecurity's CuaimaCrypt Initializator");
        this.Hebra.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (ValhalaSecurity.this.vLog != null) {
                    ValhalaSecurity.this.vLog.LogMessage(2, 64, t.getName(), e.getMessage());
                } else {
                    Logger.getLogger(t.getName()).log(Level.SEVERE, null, e.getMessage());
                }
            }
        });
        this.Hebra.start();
    }

    public static synchronized ValhalaSecurity getInstance(String SALTPATH, LoggerManager pLog) {
        if (instance == null) {
            instance = new ValhalaSecurity(SALTPATH, pLog);
        }
        return instance;
    }

    public synchronized boolean CodecIsReady() {
        return this.CODECSOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSALT() {
        StringBuffer SBuf;
        CuaimaText Ctxt = null;
        FileManager SALTFILE = new FileManager(this.SALTPATH);
        SALTFILE = new FileManager(this.SALTPATH + SALTFILE.getSeparador() + this.SALTFILENAME);
        String lSALT = null;
        try {
            Ctxt = new CuaimaText(this.VHID, this.NUMBLOCKS);
        }
        catch (UtilsException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            }
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
        }
        if (SALTFILE.Exists()) {
            try {
                long NumBytesRead;
                SALTFILE.Open(0);
                SBuf = new StringBuffer();
                byte[] Buffer = new byte[4096];
                while ((NumBytesRead = SALTFILE.Read(Buffer)) > 0L) {
                    if (NumBytesRead < (long)Buffer.length) {
                        ArrayUtils.resizeArray((Object)Buffer, (int)((int)NumBytesRead));
                    }
                    SBuf.append(new String(Buffer, "UTF-16"));
                }
                lSALT = Ctxt.Decodec(SBuf.toString());
            }
            catch (UnsupportedEncodingException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            catch (NullPointerException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                try {
                    SALTFILE.Close();
                }
                catch (UtilsException e) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
        }
        if (lSALT == null) {
            try {
                lSALT = EnvironmentUtils.genSALT((LoggerManager)this.vLog);
                SBuf = new StringBuffer(Ctxt.Codec(lSALT, 18));
                SALTFILE.Open(1);
                SALTFILE.Write(SBuf.toString().getBytes("UTF-16"));
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            catch (IOException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            catch (NullPointerException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                try {
                    SALTFILE.Close();
                }
                catch (UtilsException e) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
        }
        return lSALT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ProtectIntRecord(int orgRecord) {
        String ProtdRecord = null;
        byte[] BinProtdRecord = null;
        byte[] BinUnProtdRecord = null;
        int[] TempOrgRecord = null;
        this.binaryLock.lock();
        try {
            this.cBinary.Reset();
            TempOrgRecord = new int[]{orgRecord};
            BinUnProtdRecord = Converter.int2byte((int[])TempOrgRecord);
            BinProtdRecord = this.cBinary.Codec(BinUnProtdRecord, 52);
            ProtdRecord = Base64.encodeBytes((byte[])BinProtdRecord, (int)4);
        }
        catch (IOException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
        }
        catch (UtilsException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
        }
        finally {
            this.binaryLock.unlock();
        }
        return ProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int UnprotectIntRecord(String ProtdRecord) {
        int UnProtdRecord = 0;
        byte[] BinProtdRecord = null;
        byte[] BinUnProtdRecord = null;
        int[] TempOrgRecord = null;
        if (ProtdRecord != null && ProtdRecord.length() > 0) {
            this.binaryLock.lock();
            try {
                this.cBinary.Reset();
                BinProtdRecord = Base64.decode((String)ProtdRecord, (int)4);
                BinUnProtdRecord = this.cBinary.Decodec(BinProtdRecord);
                TempOrgRecord = Converter.byte2int((byte[])BinUnProtdRecord);
                if (TempOrgRecord.length > 1) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 32, this.getClass().getSimpleName(), "Unprotected value Int length is " + String.valueOf(TempOrgRecord.length));
                    } else {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unprotected value Int length is " + String.valueOf(TempOrgRecord.length));
                    }
                }
                UnProtdRecord = TempOrgRecord[0];
            }
            catch (IOException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.binaryLock.unlock();
            }
        }
        return UnProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ProtectLongRecord(long orgRecord) {
        String ProtdRecord = null;
        byte[] BinProtdRecord = null;
        byte[] BinUnProtdRecord = null;
        long[] TempOrgRecord = null;
        this.binaryLock.lock();
        try {
            this.cBinary.Reset();
            TempOrgRecord = new long[]{orgRecord};
            BinUnProtdRecord = Converter.long2byte((long[])TempOrgRecord);
            BinProtdRecord = this.cBinary.Codec(BinUnProtdRecord, 52);
            ProtdRecord = Base64.encodeBytes((byte[])BinProtdRecord, (int)4);
        }
        catch (IOException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
        }
        catch (UtilsException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
        }
        finally {
            this.binaryLock.unlock();
        }
        return ProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long UnprotectLongRecord(String ProtdRecord) {
        long UnProtdRecord = 0L;
        byte[] BinProtdRecord = null;
        byte[] BinUnProtdRecord = null;
        long[] TempOrgRecord = null;
        if (ProtdRecord != null && ProtdRecord.length() > 0) {
            this.binaryLock.lock();
            try {
                this.cBinary.Reset();
                BinProtdRecord = Base64.decode((String)ProtdRecord, (int)4);
                BinUnProtdRecord = this.cBinary.Decodec(BinProtdRecord);
                TempOrgRecord = Converter.byte2long((byte[])BinUnProtdRecord);
                if (TempOrgRecord.length > 1) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 32, this.getClass().getSimpleName(), "Unprotected value Long length is " + String.valueOf(TempOrgRecord.length));
                    } else {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unprotected value Long length is " + String.valueOf(TempOrgRecord.length));
                    }
                }
                UnProtdRecord = TempOrgRecord[0];
            }
            catch (IOException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.binaryLock.unlock();
            }
        }
        return UnProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ProtectDoubleRecord(double orgRecord) {
        String ProtdRecord = null;
        byte[] BinProtdRecord = null;
        byte[] BinUnProtdRecord = null;
        long[] TempOrgRecord = null;
        this.binaryLock.lock();
        try {
            this.cBinary.Reset();
            TempOrgRecord = new long[]{Double.doubleToLongBits(orgRecord)};
            BinUnProtdRecord = Converter.long2byte((long[])TempOrgRecord);
            BinProtdRecord = this.cBinary.Codec(BinUnProtdRecord, 52);
            ProtdRecord = Base64.encodeBytes((byte[])BinProtdRecord, (int)4);
        }
        catch (IOException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
        }
        catch (UtilsException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
        }
        finally {
            this.binaryLock.unlock();
        }
        return ProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double UnprotectDoubleRecord(String ProtdRecord) {
        double UnProtdRecord = 0.0;
        byte[] BinProtdRecord = null;
        byte[] BinUnProtdRecord = null;
        long[] TempOrgRecord = null;
        if (ProtdRecord != null && ProtdRecord.length() > 0) {
            this.binaryLock.lock();
            try {
                this.cBinary.Reset();
                BinProtdRecord = Base64.decode((String)ProtdRecord, (int)4);
                BinUnProtdRecord = this.cBinary.Decodec(BinProtdRecord);
                TempOrgRecord = Converter.byte2long((byte[])BinUnProtdRecord);
                if (TempOrgRecord.length > 1) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 32, this.getClass().getSimpleName(), "Unprotected value Long length is " + String.valueOf(TempOrgRecord.length));
                    } else {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unprotected value Long length is " + String.valueOf(TempOrgRecord.length));
                    }
                }
                UnProtdRecord = Double.longBitsToDouble(TempOrgRecord[0]);
            }
            catch (IOException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.binaryLock.unlock();
            }
        }
        return UnProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ProtectBooleanRecord(boolean orgRecord) {
        String ProtdRecord = null;
        byte[] BinProtdRecord = null;
        byte[] BinUnProtdRecord = null;
        this.binaryLock.lock();
        try {
            this.cBinary.Reset();
            BinUnProtdRecord = new byte[]{!orgRecord ? (byte)0 : 15};
            BinProtdRecord = this.cBinary.Codec(BinUnProtdRecord, 52);
            ProtdRecord = Base64.encodeBytes((byte[])BinProtdRecord, (int)4);
        }
        catch (IOException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
        }
        catch (UtilsException e) {
            if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
        }
        finally {
            this.binaryLock.unlock();
        }
        return ProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean UnprotectBooleanRecord(String ProtdRecord) {
        boolean UnProtdRecord = false;
        byte[] BinProtdRecord = null;
        byte[] BinUnProtdRecord = null;
        if (ProtdRecord != null && ProtdRecord.length() > 0) {
            this.binaryLock.lock();
            try {
                this.cBinary.Reset();
                BinProtdRecord = Base64.decode((String)ProtdRecord, (int)4);
                BinUnProtdRecord = this.cBinary.Decodec(BinProtdRecord);
                if (BinUnProtdRecord.length > 1) {
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 32, this.getClass().getSimpleName(), "Unprotected value Long length is " + String.valueOf(BinUnProtdRecord.length));
                    } else {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unprotected value Long length is " + String.valueOf(BinUnProtdRecord.length));
                    }
                }
                if (BinUnProtdRecord[0] == 15) {
                    UnProtdRecord = true;
                }
            }
            catch (IOException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.binaryLock.unlock();
            }
        }
        return UnProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ProtectRecord(String orgRecord) {
        String ProtdRecord = null;
        if (orgRecord != null && orgRecord.length() > 0) {
            this.textLock.lock();
            try {
                this.cText.Reset();
                ProtdRecord = this.cText.Codec(orgRecord, 18);
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.textLock.unlock();
            }
        }
        return ProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String UnprotectRecord(String ProtdRecord) {
        String orgRecord = null;
        if (ProtdRecord != null && ProtdRecord.length() > 0) {
            this.textLock.lock();
            try {
                this.cText.Reset();
                orgRecord = this.cText.Decodec(ProtdRecord);
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.textLock.unlock();
            }
        }
        return orgRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] ProtectRecord(byte[] orgRecord) {
        byte[] ProtdRecord = null;
        if (orgRecord != null && orgRecord.length > 0) {
            this.binaryLock.lock();
            try {
                this.cBinary.Reset();
                ProtdRecord = this.cBinary.Codec(orgRecord, 18);
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.binaryLock.unlock();
            }
        }
        return ProtdRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] UnprotectRecord(byte[] ProtdRecord) {
        byte[] orgRecord = null;
        if (ProtdRecord != null && ProtdRecord.length > 0) {
            this.binaryLock.lock();
            try {
                this.cBinary.Reset();
                orgRecord = this.cBinary.Decodec(ProtdRecord);
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.binaryLock.unlock();
            }
        }
        return orgRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ProtectFile(FileManager LocalFile) {
        if (LocalFile.Exists()) {
            if (LocalFile.getFileLength() > 0L) {
                this.fileLock.lock();
                try {
                    this.cFile.Reset();
                    this.cFile.Codec(LocalFile, null, 9);
                    int OldProgress = -1;
                    while (!this.cFile.isDone()) {
                        int Progress = this.cFile.Progress();
                        if (Progress > OldProgress && Progress < 100) {
                            if (this.vLog != null) {
                                this.vLog.LogMessage(1, 16, this.getClass().getSimpleName(), "Coding " + LocalFile.getFileName() + " [" + String.valueOf(Progress) + " %]");
                            } else {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Coding " + LocalFile.getFileName() + " [" + String.valueOf(Progress) + " %]");
                            }
                            OldProgress = Progress;
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            if (this.vLog != null) {
                                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                                continue;
                            }
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                        }
                    }
                    if (this.cFile.Progress() == 100) {
                        if (this.vLog != null) {
                            this.vLog.LogMessage(1, 16, this.getClass().getSimpleName(), "Coding " + LocalFile.getFileName() + " [" + String.valueOf(this.cFile.Progress()) + " %]");
                        }
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Coding " + LocalFile.getFileName() + " [" + String.valueOf(this.cFile.Progress()) + " %]");
                    }
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), "Error Coding " + LocalFile.getFileName());
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error Coding " + LocalFile.getFileName());
                }
                finally {
                    this.fileLock.unlock();
                }
            } else if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), LocalFile.getFileName() + " have ZERO size");
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, LocalFile.getFileName() + " have ZERO size");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), LocalFile.getFileName() + " NO exist");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, LocalFile.getFileName() + " NO exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UnprotectFile(FileManager ProtectedLocalFile) {
        if (ProtectedLocalFile.Exists()) {
            if (ProtectedLocalFile.getFileLength() > 0L) {
                this.fileLock.lock();
                try {
                    this.cFile.Reset();
                    this.cFile.Decodec(ProtectedLocalFile, null);
                    int OldProgress = -1;
                    while (!this.cFile.isDone()) {
                        int Progress = this.cFile.Progress();
                        if (Progress > OldProgress && Progress < 100) {
                            if (this.vLog != null) {
                                this.vLog.LogMessage(1, 16, this.getClass().getSimpleName(), "Decoding " + ProtectedLocalFile.getFileName() + " [" + String.valueOf(Progress) + " %]");
                            } else {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Decoding " + ProtectedLocalFile.getFileName() + " [" + String.valueOf(Progress) + " %]");
                            }
                            OldProgress = Progress;
                        }
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            if (this.vLog != null) {
                                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                                continue;
                            }
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                        }
                    }
                    if (this.cFile.Progress() == 100) {
                        if (this.vLog != null) {
                            this.vLog.LogMessage(1, 16, this.getClass().getSimpleName(), "Decoding " + ProtectedLocalFile.getFileName() + " [" + String.valueOf(this.cFile.Progress()) + " %]");
                        }
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Decoding " + ProtectedLocalFile.getFileName() + " [" + String.valueOf(this.cFile.Progress()) + " %]");
                    }
                    if (this.vLog != null) {
                        this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), "Error Decoding " + ProtectedLocalFile.getFileName());
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Error Decoding " + ProtectedLocalFile.getFileName());
                }
                finally {
                    this.fileLock.unlock();
                }
            } else if (this.vLog != null) {
                this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), ProtectedLocalFile.getFileName() + " have ZERO size");
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ProtectedLocalFile.getFileName() + " have ZERO size");
            }
        } else if (this.vLog != null) {
            this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), ProtectedLocalFile.getFileName() + " NO exist");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ProtectedLocalFile.getFileName() + " NO exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean lCodecOK;
        ValhalaSecurity valhalaSecurity = this;
        synchronized (valhalaSecurity) {
            lCodecOK = this.CODECSOK;
        }
        if (!lCodecOK) {
            this.binaryLock.lock();
            this.textLock.lock();
            this.fileLock.lock();
            try {
                this.cBinary = new CuaimaBinary(this.SALT, this.NUMBLOCKS);
                this.cText = new CuaimaText(this.SALT, this.NUMBLOCKS);
                this.cFile = new CuaimaFile(this.SALT, this.NUMBLOCKS, this.vLog);
                lCodecOK = true;
            }
            catch (UtilsException e) {
                if (this.vLog != null) {
                    this.vLog.LogMessage(2, 64, this.getClass().getSimpleName(), e.getLocalizedMessage());
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                }
            }
            finally {
                this.binaryLock.unlock();
                this.textLock.unlock();
                this.fileLock.unlock();
            }
            valhalaSecurity = this;
            synchronized (valhalaSecurity) {
                this.CODECSOK = lCodecOK;
            }
        }
    }
}

