/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.crypto.aes.utils;

import com.valhalanetworks.crypto.aes.CuaimaAES;
import com.valhalanetworks.crypto.digest.BaseHash;
import com.valhalanetworks.crypto.digest.CRC32;
import com.valhalanetworks.crypto.digest.CRC64;
import com.valhalanetworks.crypto.digest.Has160;
import com.valhalanetworks.crypto.digest.Haval;
import com.valhalanetworks.crypto.digest.MD2;
import com.valhalanetworks.crypto.digest.MD4;
import com.valhalanetworks.crypto.digest.MD5;
import com.valhalanetworks.crypto.digest.RipeMD128;
import com.valhalanetworks.crypto.digest.RipeMD160;
import com.valhalanetworks.crypto.digest.Sha0;
import com.valhalanetworks.crypto.digest.Sha160;
import com.valhalanetworks.crypto.digest.Sha224;
import com.valhalanetworks.crypto.digest.Sha256;
import com.valhalanetworks.crypto.digest.Sha384;
import com.valhalanetworks.crypto.digest.Sha512;
import com.valhalanetworks.crypto.digest.Tiger;
import com.valhalanetworks.crypto.digest.Tiger128;
import com.valhalanetworks.crypto.digest.Tiger160;
import com.valhalanetworks.crypto.digest.Tiger2;
import com.valhalanetworks.crypto.digest.Whirlpool;
import com.valhalanetworks.crypto.digest.Whirlpool2000;
import com.valhalanetworks.crypto.digest.Whirlpool2003;
import com.valhalanetworks.crypto.interfaces.CryptoText;
import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.converters.Base64;
import com.valhalanetworks.utils.converters.Converter;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class AESText
implements CryptoText {
    private CuaimaAES AES;
    private int PasswdLength;
    private double HeadPos;
    private int LineLength = 76;
    private static final int HASHMASK = 62;

    private strictfp void CalcHeadPos(String Password) {
        long Temp = 0L;
        for (int i = 0; i < Password.length(); ++i) {
            Temp += (long)Password.charAt(i);
        }
        this.HeadPos = Temp;
        this.HeadPos /= 100.0;
        Temp = (long)this.HeadPos;
        this.HeadPos -= (double)Temp;
    }

    public AESText() {
        this.PasswdLength = -1;
        this.AES = new CuaimaAES();
    }

    public AESText(String Password) throws UtilsException {
        this.AES = new CuaimaAES();
        if (this.AES.Password(Password) != 0) {
            this.PasswdLength = -1;
            throw new UtilsException("ERROR: NO se pudo inicializar AESText, falla al inicializar el Password", 4);
        }
        this.PasswdLength = Password.length();
        this.CalcHeadPos(Password);
    }

    @Override
    public boolean Password(String Passw) throws UtilsException {
        boolean salida = false;
        this.PasswdLength = -1;
        if (this.AES != null) {
            if (this.AES.Password(Passw) != 0) {
                throw new UtilsException("ERROR: NO se pudo inicializar la clave en AESText", 4);
            }
            this.PasswdLength = Passw.length();
            this.CalcHeadPos(Passw);
            salida = true;
        }
        return salida;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String Codec(String Input, int Opciones) throws UtilsException {
        long[] A;
        int i;
        int j;
        long MessageLength;
        byte[] Digest;
        BaseHash Hash;
        String Salida = null;
        byte[] k = null;
        if (this.PasswdLength <= 0) throw new UtilsException("ERROR: NO se puede codificar el texto porque no se ha establecido una Password", 4);
        MersenneTwisterPlus Rand = new MersenneTwisterPlus();
        int HashType = Opciones & 0x3E;
        switch (HashType) {
            case 2: {
                Hash = new Whirlpool2003();
                break;
            }
            case 4: {
                Hash = new Whirlpool2000();
                break;
            }
            case 6: {
                Hash = new Whirlpool();
                break;
            }
            case 8: {
                Hash = new Sha0();
                break;
            }
            case 10: {
                Hash = new Sha160();
                break;
            }
            case 12: {
                Hash = new Sha224();
                break;
            }
            case 14: {
                Hash = new Sha256();
                break;
            }
            case 16: {
                Hash = new Sha384();
                break;
            }
            case 18: {
                Hash = new Sha512();
                break;
            }
            case 20: {
                Hash = new Tiger();
                break;
            }
            case 22: {
                Hash = new Tiger2();
                break;
            }
            case 24: {
                Hash = new Tiger128();
                break;
            }
            case 26: {
                Hash = new Tiger160();
                break;
            }
            case 28: {
                Hash = new RipeMD128();
                break;
            }
            case 30: {
                Hash = new RipeMD160();
                break;
            }
            case 32: {
                Hash = new MD2();
                break;
            }
            case 34: {
                Hash = new MD4();
                break;
            }
            case 36: {
                Hash = new MD5();
                break;
            }
            case 38: {
                Hash = new Haval(16);
                break;
            }
            case 40: {
                Hash = new Haval(20);
                break;
            }
            case 42: {
                Hash = new Haval(24);
                break;
            }
            case 44: {
                Hash = new Haval(28);
                break;
            }
            case 46: {
                Hash = new Haval(32);
                break;
            }
            case 48: {
                Hash = new Has160();
                break;
            }
            case 50: {
                Hash = new CRC32();
                break;
            }
            case 52: {
                Hash = new CRC64();
                break;
            }
            case 0: {
                Hash = null;
                break;
            }
            default: {
                Hash = new Whirlpool2003();
            }
        }
        if (HashType != 0) {
            Digest = Input.getBytes(StandardCharsets.UTF_16);
            MessageLength = Digest.length;
            k = Hash.Hash(Digest);
            Digest = (byte[])ArrayUtils.resizeArray(Digest, Digest.length + Hash.hashSize());
            j = 0;
            for (i = Digest.length - Hash.hashSize(); i < Digest.length; ++i) {
                Digest[i] = k[j];
                ++j;
            }
        } else {
            Digest = Input.getBytes(StandardCharsets.UTF_16);
            MessageLength = Digest.length;
        }
        long[] Header = new long[]{Rand.nextLong() << 32 | Converter.byte2long(new String("CAESSEAC").getBytes())[0] >>> 32, Converter.byte2long(new String("CAESSEAC").getBytes())[0] << 32 | Rand.nextLong() >>> 32, MessageLength, Rand.nextLong() << 32};
        Header[3] = Header[3] | (long)(HashType << 26);
        Header[3] = Header[3] | 1L;
        long[] CodecBuffer = new long[(int)((double)Header.length + 2.0 * Math.ceil(Math.ceil((double)Digest.length / 8.0) / 2.0))];
        double Temp = this.HeadPos;
        long HPosc = (long)(Temp *= (double)CodecBuffer.length);
        if ((long)CodecBuffer.length - (HPosc = (long)(2.0 * Math.ceil((double)HPosc / 2.0))) < (long)Header.length) {
            HPosc = CodecBuffer.length - Header.length;
        }
        for (i = 0; i < Header.length; ++i) {
            CodecBuffer[(int)(HPosc + (long)i)] = Header[i];
        }
        k = new byte[8];
        long BufferPost = HPosc + (long)Header.length;
        for (i = Header.length; i < CodecBuffer.length; ++i) {
            if (BufferPost == (long)CodecBuffer.length) {
                BufferPost = 0L;
            }
            for (j = 0; j < 8; ++j) {
                k[j] = 8 * (i - Header.length) + j < Digest.length ? Digest[8 * (i - Header.length) + j] : Rand.nextByte();
            }
            A = Converter.byte2long(k);
            CodecBuffer[(int)BufferPost] = A[0];
            ++BufferPost;
        }
        A = new long[2];
        BufferPost = HPosc;
        for (i = 0; i < CodecBuffer.length; i += 2) {
            if (BufferPost == (long)CodecBuffer.length) {
                BufferPost = 0L;
            }
            A[0] = CodecBuffer[(int)BufferPost];
            A[1] = CodecBuffer[(int)BufferPost + 1];
            k = Converter.long2byte(A);
            k = this.AES.Encrypt(k);
            A = Converter.byte2long(k);
            CodecBuffer[(int)BufferPost] = A[0];
            CodecBuffer[(int)BufferPost + 1] = A[1];
            BufferPost += 2L;
        }
        try {
            Salida = Base64.encodeBytes(Converter.long2byte(CodecBuffer), 4);
            if ((Opciones & 1) != 1) return Salida;
            return this.LineBreak(Salida);
        }
        catch (IOException ex) {
            throw new UtilsException("ERROR: NO se puede codificar el texto a Base64", 5);
        }
    }

    @Override
    public String Decodec(String Input) throws UtilsException {
        String Salida = null;
        long[] DecodecBuffer = null;
        byte[] OrgDigest = null;
        byte[] NewDigest = null;
        if (this.PasswdLength > 0) {
            int i;
            int HashType = 0;
            try {
                Input = this.TrimMessage(Input);
                DecodecBuffer = Converter.byte2long(Base64.decode(Input, 4));
            }
            catch (IOException ex) {
                throw new UtilsException("ERROR: NO se puede decodificar el texto en Base64", 6);
            }
            long[] Header = new long[4];
            double Temp = this.HeadPos;
            long HPosc = (long)(Temp *= (double)DecodecBuffer.length);
            HPosc = (long)(2.0 * Math.ceil((double)HPosc / 2.0));
            if ((long)DecodecBuffer.length - HPosc < (long)Header.length) {
                HPosc = DecodecBuffer.length - Header.length;
            }
            long[] A = new long[2];
            long BufferPost = HPosc;
            for (i = 0; i < DecodecBuffer.length; i += 2) {
                if (BufferPost == (long)DecodecBuffer.length) {
                    BufferPost = 0L;
                }
                A[0] = DecodecBuffer[(int)BufferPost];
                A[1] = DecodecBuffer[(int)BufferPost + 1];
                byte[] k = Converter.long2byte(A);
                k = this.AES.Decrypt(k);
                A = Converter.byte2long(k);
                DecodecBuffer[(int)BufferPost] = A[0];
                DecodecBuffer[(int)BufferPost + 1] = A[1];
                BufferPost += 2L;
            }
            for (i = 0; i < Header.length; ++i) {
                Header[i] = DecodecBuffer[(int)(HPosc + (long)i)];
            }
            long[] HTemp = new long[]{Header[0] << 32 | Header[1] >>> 32};
            String HeaderDec = new String(Converter.long2byte(HTemp));
            if (HeaderDec.contentEquals(new StringBuffer("CAESSEAC"))) {
                int Version = (int)(Header[3] & 1L);
                if (Version == 1) {
                    BaseHash Hash;
                    HashType = (int)(Header[3] >>> 26) & 0x3E;
                    switch (HashType) {
                        case 2: {
                            Hash = new Whirlpool2003();
                            break;
                        }
                        case 4: {
                            Hash = new Whirlpool2000();
                            break;
                        }
                        case 6: {
                            Hash = new Whirlpool();
                            break;
                        }
                        case 8: {
                            Hash = new Sha0();
                            break;
                        }
                        case 10: {
                            Hash = new Sha160();
                            break;
                        }
                        case 12: {
                            Hash = new Sha224();
                            break;
                        }
                        case 14: {
                            Hash = new Sha256();
                            break;
                        }
                        case 16: {
                            Hash = new Sha384();
                            break;
                        }
                        case 18: {
                            Hash = new Sha512();
                            break;
                        }
                        case 20: {
                            Hash = new Tiger();
                            break;
                        }
                        case 22: {
                            Hash = new Tiger2();
                            break;
                        }
                        case 24: {
                            Hash = new Tiger128();
                            break;
                        }
                        case 26: {
                            Hash = new Tiger160();
                            break;
                        }
                        case 28: {
                            Hash = new RipeMD128();
                            break;
                        }
                        case 30: {
                            Hash = new RipeMD160();
                            break;
                        }
                        case 32: {
                            Hash = new MD2();
                            break;
                        }
                        case 34: {
                            Hash = new MD4();
                            break;
                        }
                        case 36: {
                            Hash = new MD5();
                            break;
                        }
                        case 38: {
                            Hash = new Haval(16);
                            break;
                        }
                        case 40: {
                            Hash = new Haval(20);
                            break;
                        }
                        case 42: {
                            Hash = new Haval(24);
                            break;
                        }
                        case 44: {
                            Hash = new Haval(28);
                            break;
                        }
                        case 46: {
                            Hash = new Haval(32);
                            break;
                        }
                        case 48: {
                            Hash = new Has160();
                            break;
                        }
                        case 50: {
                            Hash = new CRC32();
                            break;
                        }
                        case 52: {
                            Hash = new CRC64();
                            break;
                        }
                        case 0: {
                            Hash = null;
                            break;
                        }
                        default: {
                            Hash = new Whirlpool2003();
                        }
                    }
                    byte[] OutBuffer = Hash != null ? new byte[(int)Header[2] + Hash.hashSize()] : new byte[(int)Header[2]];
                    BufferPost = HPosc + (long)Header.length;
                    for (i = 0; i < OutBuffer.length; i += 8) {
                        if (BufferPost == (long)DecodecBuffer.length) {
                            BufferPost = 0L;
                        }
                        HTemp[0] = DecodecBuffer[(int)BufferPost];
                        ArrayUtils.arrayCopy(Converter.long2byte(HTemp), 0, OutBuffer, i, 8);
                        ++BufferPost;
                    }
                    if (Hash != null) {
                        OrgDigest = (byte[])ArrayUtils.subArray(OutBuffer, (int)Header[2], Hash.hashSize());
                    }
                    OutBuffer = (byte[])ArrayUtils.resizeArray(OutBuffer, (int)Header[2]);
                    Salida = new String(OutBuffer, StandardCharsets.UTF_16);
                    if (Hash != null && !Arrays.equals(OrgDigest, NewDigest = Hash.Hash(OutBuffer))) {
                        Salida = null;
                        throw new UtilsException("ERROR: HASH NO COINCIDEN", 1);
                    }
                } else {
                    throw new UtilsException("ERROR: Version de AESText NO Reconocida", 2);
                }
            }
        }
        return Salida;
    }

    private String TrimMessage(String Entrada) {
        Entrada = Entrada.trim();
        Entrada = Entrada.replace("\n", "");
        Entrada = Entrada.replace(" ", "");
        return Entrada;
    }

    private String LineBreak(String Input) throws UtilsException {
        StringBuffer Separador = new StringBuffer(Input);
        if (this.LineLength > 1) {
            for (int i = this.LineLength; i < Separador.length(); i += this.LineLength + 1) {
                Separador = Separador.insert(i, "\n");
            }
        } else {
            throw new UtilsException("WARNING: La longitud de las lineas codificadas es menos a dos caracteres");
        }
        Separador.trimToSize();
        return Separador.toString();
    }

    @Override
    public int getLineLength() {
        return this.LineLength;
    }

    @Override
    public void setLineLength(int LineLength) {
        if (LineLength > 1) {
            this.LineLength = LineLength;
        }
    }
}

