/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.crypto.cuaimacrypt;

import com.valhalanetworks.utils.random.MersenneTwisterPlus;

public class ShiftCodec {
    private long seed;
    private long shift_register;
    private int posup;
    private int posdown;
    private int ShiftLeap;
    private int win_a;
    private int win_b;
    private int entrada;
    private int salida;
    private ShiftCodec upchain;
    private ShiftCodec downchain;
    private MersenneTwisterPlus rnd;

    ShiftCodec() {
        this.rnd = new MersenneTwisterPlus();
        this.shift_register = this.seed = this.rnd.nextLong();
        this.upchain = null;
        this.downchain = null;
        this.posup = 5;
        this.posdown = 15;
        this.ShiftLeap = 1;
        this.win_a = 9;
        this.win_b = 27;
        this.entrada = 0;
        this.salida = 0;
    }

    ShiftCodec(long semilla) {
        this.shift_register = this.seed = semilla;
        this.upchain = null;
        this.downchain = null;
        this.posup = 5;
        this.posdown = 15;
        this.ShiftLeap = 1;
        this.win_a = 9;
        this.win_b = 27;
        this.entrada = 0;
        this.salida = 0;
    }

    ShiftCodec(long semilla, ShiftCodec up, ShiftCodec down) {
        this.shift_register = this.seed = semilla;
        this.upchain = up;
        this.downchain = down;
        this.posup = 5;
        this.posdown = 15;
        this.ShiftLeap = 1;
        this.win_a = 9;
        this.win_b = 27;
        this.entrada = 0;
        this.salida = 0;
    }

    protected void finalize() throws Throwable {
        try {
            this.seed = this.rnd.nextLong();
            this.shift_register = this.rnd.nextLong();
            this.posup = this.rnd.nextInt();
            this.posdown = this.rnd.nextInt();
            this.ShiftLeap = this.rnd.nextInt();
            this.win_a = this.rnd.nextInt();
            this.win_b = this.rnd.nextInt();
            this.entrada = this.rnd.nextInt();
            this.salida = this.rnd.nextInt();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.shift_register = this.seed = seed;
    }

    public long getShiftCodec_state() {
        return this.shift_register;
    }

    public void setShiftCodec_state(long state) {
        this.shift_register = state;
    }

    public void Reset() {
        this.shift_register = this.seed;
    }

    public void RamdomSeed() {
        this.shift_register = this.seed = this.rnd.nextLong();
    }

    public void UpChain(ShiftCodec up) {
        this.upchain = up;
    }

    public void DownChain(ShiftCodec down) {
        this.downchain = down;
    }

    public void Chain(ShiftCodec up, ShiftCodec down) {
        this.upchain = up;
        this.downchain = down;
    }

    public int GetBits(int pos) {
        int Salida;
        if (pos < 32 && pos >= 0) {
            long SR = this.shift_register;
            Salida = (int)(SR >>>= pos);
        } else {
            Salida = -1;
        }
        return Salida;
    }

    public void ShiftCdec() {
        int a = this.GetBits(this.win_a) ^ this.upchain.GetBits(this.posup);
        int b = this.GetBits(this.win_b) ^ this.downchain.GetBits(this.posdown);
        a ^= b;
        b = a ^ this.entrada;
        long SR = b;
        this.shift_register >>>= this.ShiftLeap;
        this.shift_register = (SR <<= 31) ^ this.shift_register;
    }

    public void ShiftDCdec() {
        int a = this.GetBits(this.win_a) ^ this.upchain.GetBits(this.posup);
        int b = this.GetBits(this.win_b) ^ this.downchain.GetBits(this.posdown);
        a ^= b;
        b = a ^ this.salida;
        long SR = b;
        this.shift_register >>>= this.ShiftLeap;
        this.shift_register = (SR <<= 31) ^ this.shift_register;
    }

    public int BitsCodec(int in) {
        this.entrada = in;
        this.salida = (int)this.shift_register;
        this.salida = this.entrada ^ this.salida;
        return this.salida;
    }

    public int BitsDecodec(int in) {
        this.entrada = in;
        this.salida = (int)this.shift_register;
        this.salida = this.entrada ^ this.salida;
        return this.salida;
    }

    public int getPosUp() {
        return this.posup;
    }

    public void setPosUp(int posup) {
        this.posup = posup < 32 && posup >= 0 ? posup : 29;
    }

    public int getPosDown() {
        return this.posdown;
    }

    public void setPosDown(int posdown) {
        this.posdown = posdown < 32 && posdown >= 0 ? posdown : 9;
    }

    public int getShiftLeap() {
        return this.ShiftLeap;
    }

    public void setShiftLeap(int shiftPeap) {
        this.ShiftLeap = shiftPeap > 0 && shiftPeap < 15 ? shiftPeap : 7;
    }

    public int getWinA() {
        return this.win_a;
    }

    public void setWinA(int win_A) {
        if (win_A < 32 && win_A >= 0) {
            this.win_a = win_A;
        }
    }

    public int getWinB() {
        return this.win_b;
    }

    public void setWinB(int win_B) {
        if (win_B < 32 && win_B >= 0) {
            this.win_b = win_B;
        }
    }

    public int getEntrada() {
        return this.entrada;
    }

    public int getSalida() {
        return this.salida;
    }

    public boolean CheckUpChain() {
        boolean Salida = true;
        if (this.upchain == null) {
            Salida = false;
        }
        return Salida;
    }

    public boolean CheckDownChain() {
        boolean Salida = true;
        if (this.downchain == null) {
            Salida = false;
        }
        return Salida;
    }

    public boolean CheckChain() {
        boolean Salida = true;
        if (this.downchain == null || this.upchain == null) {
            Salida = false;
        }
        return Salida;
    }
}

