/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.disruptor;

import com.valhalanetworks.utils.disruptor.AbstractSequencer;
import com.valhalanetworks.utils.disruptor.InsufficientCapacityException;
import com.valhalanetworks.utils.disruptor.Sequence;
import com.valhalanetworks.utils.disruptor.WaitStrategy;
import com.valhalanetworks.utils.disruptor.util.Util;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class MultiProducerSequencer
extends AbstractSequencer {
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock rl = this.rwl.readLock();
    private final Lock wl = this.rwl.writeLock();
    private final Sequence gatingSequenceCache = new Sequence(-1L);
    private final int[] availableBuffer;
    private final int indexMask;
    private final int indexShift;

    public MultiProducerSequencer(int bufferSize, WaitStrategy waitStrategy) {
        super(bufferSize, waitStrategy);
        this.availableBuffer = new int[bufferSize];
        this.indexMask = bufferSize - 1;
        this.indexShift = Util.log2(bufferSize);
        this.initialiseAvailableBuffer();
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.hasAvailableCapacity(this.gatingSequences, requiredCapacity, this.cursor.get());
    }

    private boolean hasAvailableCapacity(Sequence[] gatingSequences, int requiredCapacity, long cursorValue) {
        long wrapPoint = cursorValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.gatingSequenceCache.get();
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > cursorValue) {
            long minSequence = Util.getMinimumSequence(gatingSequences, cursorValue);
            this.gatingSequenceCache.set(minSequence);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void claim(long sequence) {
        this.cursor.set(sequence);
    }

    @Override
    public long next() {
        return this.next(1);
    }

    @Override
    public long next(int n) {
        long next;
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        while (true) {
            long cachedGatingSequence;
            long current;
            long wrapPoint;
            if ((wrapPoint = (next = (current = this.cursor.get()) + (long)n) - (long)this.bufferSize) > (cachedGatingSequence = this.gatingSequenceCache.get()) || cachedGatingSequence > current) {
                long gatingSequence = Util.getMinimumSequence(this.gatingSequences, current);
                if (wrapPoint > gatingSequence) {
                    LockSupport.parkNanos(1L);
                    continue;
                }
                this.gatingSequenceCache.set(gatingSequence);
                continue;
            }
            if (this.cursor.compareAndSet(current, next)) break;
        }
        return next;
    }

    @Override
    public long tryNext() throws InsufficientCapacityException {
        return this.tryNext(1);
    }

    @Override
    public long tryNext(int n) throws InsufficientCapacityException {
        long next;
        long current;
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        do {
            current = this.cursor.get();
            next = current + (long)n;
            if (this.hasAvailableCapacity(this.gatingSequences, n, current)) continue;
            throw InsufficientCapacityException.INSTANCE;
        } while (!this.cursor.compareAndSet(current, next));
        return next;
    }

    @Override
    public long remainingCapacity() {
        long consumed = Util.getMinimumSequence(this.gatingSequences, this.cursor.get());
        long produced = this.cursor.get();
        return (long)this.getBufferSize() - (produced - consumed);
    }

    private void initialiseAvailableBuffer() {
        for (int i = this.availableBuffer.length - 1; i != 0; --i) {
            this.setAvailableBufferValue(i, -1);
        }
        this.setAvailableBufferValue(0, -1);
    }

    @Override
    public void publish(long sequence) {
        this.setAvailable(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void publish(long lo, long hi) {
        for (long l = lo; l <= hi; ++l) {
            this.setAvailable(l);
        }
        this.waitStrategy.signalAllWhenBlocking();
    }

    private void setAvailable(long sequence) {
        this.setAvailableBufferValue(this.calculateIndex(sequence), this.calculateAvailabilityFlag(sequence));
    }

    private void setAvailableBufferValue(int index, int flag) {
        this.wl.lock();
        try {
            this.availableBuffer[index] = flag;
        }
        finally {
            this.wl.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable(long sequence) {
        boolean Salida;
        int index = this.calculateIndex(sequence);
        int flag = this.calculateAvailabilityFlag(sequence);
        this.rl.lock();
        try {
            Salida = this.availableBuffer[index] == flag;
        }
        finally {
            this.rl.unlock();
        }
        return Salida;
    }

    @Override
    public long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        for (long sequence = lowerBound; sequence <= availableSequence; ++sequence) {
            if (this.isAvailable(sequence)) continue;
            return sequence - 1L;
        }
        return availableSequence;
    }

    private int calculateAvailabilityFlag(long sequence) {
        return (int)(sequence >>> this.indexShift);
    }

    private int calculateIndex(long sequence) {
        return (int)sequence & this.indexMask;
    }
}

