/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.disruptor.util;

import com.valhalanetworks.utils.disruptor.EventProcessor;
import com.valhalanetworks.utils.disruptor.Sequence;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class Util {
    public static int ceilingNextPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static long getMinimumSequence(Sequence[] sequences) {
        return Util.getMinimumSequence(sequences, Long.MAX_VALUE);
    }

    public static long getMinimumSequence(Sequence[] sequences, long minimum) {
        int n = sequences.length;
        for (int i = 0; i < n; ++i) {
            long value = sequences[i].get();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    public static Sequence[] getSequencesFor(EventProcessor ... processors) {
        Sequence[] sequences = new Sequence[processors.length];
        for (int i = 0; i < sequences.length; ++i) {
            sequences[i] = processors[i].getSequence();
        }
        return sequences;
    }

    public static long getAddressFromDirectByteBuffer(ByteBuffer buffer) {
        try {
            Field addressField = Buffer.class.getDeclaredField("address");
            addressField.setAccessible(true);
            return addressField.getLong(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to address field from ByteBuffer", e);
        }
    }

    public static int log2(int i) {
        int r = 0;
        while ((i >>= 1) != 0) {
            ++r;
        }
        return r;
    }
}

