/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.kerneltasks;

import com.valhalanetworks.utils.log.LoggerManager;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VTask
implements Comparable,
Runnable {
    public static final int PRIORITY_LOW = 1;
    public static final int PRIORITY_NORMAL = 10;
    public static final int PRIORITY_HIGH = 20;
    private int Priority;
    private long TimeStamp;
    private long NanoTimeStamp;
    private long TaskID;
    protected static LoggerManager vLogM;

    public VTask(LoggerManager vLogM) {
        MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
        this.TaskID = Random2.nextLong63();
        this.TimeStamp = System.currentTimeMillis();
        this.NanoTimeStamp = System.nanoTime();
        this.Priority = 10;
        VTask.vLogM = vLogM;
    }

    public int getPriority() {
        return this.Priority;
    }

    public void setPriority(int priority) {
        this.Priority = priority > 20 ? 20 : (priority < 1 ? 1 : priority);
    }

    public long getTaskID() {
        return this.TaskID;
    }

    public int compareTo(Object another) {
        int Result = 0;
        if (VTask.class.isInstance(another)) {
            double P1 = 0.14;
            double P2 = 0.85;
            double P3 = 0.01;
            VTask Other = (VTask)another;
            double Max = Math.max(this.TimeStamp, Other.TimeStamp);
            double ATS = (double)this.TimeStamp / Max;
            double BTS = (double)Other.TimeStamp / Max;
            Max = Math.max(this.NanoTimeStamp, Other.NanoTimeStamp);
            double ANT = (double)this.NanoTimeStamp / Max;
            double BNT = (double)Other.NanoTimeStamp / Max;
            Max = Math.max(this.Priority, Other.Priority);
            double AP = (double)this.Priority / Max;
            double BP = (double)Other.Priority / Max;
            Max = (ATS - BTS) * P1 + (BP - AP) * P2 + (ANT - BNT) * P3;
            Result = (int)Math.signum(Max);
        } else if (vLogM != null) {
            vLogM.LogMessage(2, 64, this.getClass().getName(), "Task IS NOT VTask Class");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Task IS NOT VTask Class");
        }
        return Result;
    }

    @Override
    public void run() {
        if (vLogM != null) {
            vLogM.LogMessage(2, 64, this.getClass().getName(), "Method run() NEED to be Override at Task[" + Long.toHexString(this.TaskID) + "]");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Method run() NEED to be Override at Task[" + Long.toHexString(this.TaskID) + "]");
        }
        throw new UnsupportedOperationException("Method run() NEED to be Override by Subclasses");
    }
}

