/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.math.chaos;

import com.valhalanetworks.utils.math.chaos.Atractor;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;

public strictfp class AtractorLorenz
implements Atractor {
    private double X;
    private double Y;
    private double Z;
    private double Beta = 15.026;
    private double Theta = 9.165;
    private double Gamma = 6.828;
    private double DeltaT = 0.114;
    private MersenneTwisterPlus rnd = new MersenneTwisterPlus();

    public AtractorLorenz() {
        do {
            this.X = this.rnd.nextDouble();
            if (this.X != 0.0) {
                this.X = 1.0 / this.X;
            }
            this.Y = this.rnd.nextDouble();
            if (this.Y != 0.0) {
                this.Y = 1.0 / this.Y;
            }
            this.Z = this.rnd.nextDouble();
            if (this.Z == 0.0) continue;
            this.Z = 1.0 / this.Z;
        } while (this.VerifyEquilibriumPoint(this.X, this.Y, this.Z));
    }

    private boolean VerifyEquilibriumPoint(double Xp, double Yp, double Zp) {
        boolean resultado = false;
        if (Xp == 0.0 && Yp == 0.0 && Zp == 0.0) {
            resultado = true;
        } else {
            double Xe;
            double Ze = this.Theta - 1.0;
            double Ye = Xe = Math.sqrt(this.Beta * Ze);
            if (Xp == Xe && Yp == Ye && Zp == Ze) {
                resultado = true;
            } else {
                Ye = Xe = -Xe;
                if (Xp == Xe && Yp == Ye && Zp == Ze) {
                    resultado = true;
                }
            }
        }
        return resultado;
    }

    @Override
    public void SetInitialPoint(double X0, double Y0, double Z0) {
        this.X = X0;
        this.Y = Y0;
        this.Z = Z0;
    }

    public int getNumAtractorTypes() {
        return 20;
    }

    public void SetAtractorType(int N) {
        switch (N) {
            case 0: {
                this.Gamma = 6.59;
                this.Theta = 11.786;
                this.Beta = 18.221;
                this.DeltaT = 0.095;
                break;
            }
            case 1: {
                this.Gamma = 6.828;
                this.Theta = 9.165;
                this.Beta = 15.026;
                this.DeltaT = 0.114;
                break;
            }
            case 2: {
                this.Gamma = 0.809;
                this.Theta = 18.829;
                this.Beta = 8.121;
                this.DeltaT = 0.099;
                break;
            }
            case 3: {
                this.Gamma = 8.474;
                this.Theta = 10.71;
                this.Beta = 18.602;
                this.DeltaT = 0.092;
                break;
            }
            case 4: {
                this.Gamma = 7.922;
                this.Theta = 5.877;
                this.Beta = 3.537;
                this.DeltaT = 0.158;
                break;
            }
            case 5: {
                this.Gamma = 3.715;
                this.Theta = 10.253;
                this.Beta = 15.055;
                this.DeltaT = 0.119;
                break;
            }
            case 6: {
                this.Gamma = 6.526;
                this.Theta = 4.926;
                this.Beta = 14.138;
                this.DeltaT = 0.15;
                break;
            }
            case 7: {
                this.Gamma = 0.64;
                this.Theta = 10.369;
                this.Beta = 7.046;
                this.DeltaT = 0.169;
                break;
            }
            case 8: {
                this.Gamma = 0.857;
                this.Theta = 7.938;
                this.Beta = 5.852;
                this.DeltaT = 0.222;
                break;
            }
            case 9: {
                this.Gamma = 16.23;
                this.Theta = 10.249;
                this.Beta = 6.669;
                this.DeltaT = 0.079;
                break;
            }
            case 10: {
                this.Gamma = 9.851;
                this.Theta = 6.467;
                this.Beta = 14.491;
                this.DeltaT = 0.121;
                break;
            }
            case 11: {
                this.Gamma = 4.118;
                this.Theta = 13.165;
                this.Beta = 16.705;
                this.DeltaT = 0.098;
                break;
            }
            case 12: {
                this.Gamma = 7.924;
                this.Theta = 7.757;
                this.Beta = 13.565;
                this.DeltaT = 0.124;
                break;
            }
            case 13: {
                this.Gamma = 8.939;
                this.Theta = 5.713;
                this.Beta = 2.194;
                this.DeltaT = 0.151;
                break;
            }
            case 14: {
                this.Gamma = 12.286;
                this.Theta = 14.222;
                this.Beta = 4.263;
                this.DeltaT = 0.041;
                break;
            }
            case 15: {
                this.Gamma = 8.034;
                this.Theta = 6.607;
                this.Beta = 3.268;
                this.DeltaT = 0.137;
                break;
            }
            case 16: {
                this.Gamma = 11.092;
                this.Theta = 5.897;
                this.Beta = 2.887;
                this.DeltaT = 0.132;
                break;
            }
            case 17: {
                this.Gamma = 2.675;
                this.Theta = 5.639;
                this.Beta = 1.403;
                this.DeltaT = 0.181;
                break;
            }
            case 18: {
                this.Gamma = 4.939;
                this.Theta = 4.324;
                this.Beta = 1.923;
                this.DeltaT = 0.253;
                break;
            }
            case 19: {
                this.Gamma = 9.124;
                this.Theta = 8.905;
                this.Beta = 17.614;
                this.DeltaT = 0.101;
                break;
            }
            default: {
                this.Gamma = 10.0;
                this.Theta = 28.0;
                this.Beta = 2.6666666667;
                this.DeltaT = 0.01;
            }
        }
    }

    @Override
    public void NextPoint() {
        double Xo = this.X;
        double Yo = this.Y;
        double Zo = this.Z;
        this.X = Xo + this.Gamma * (Yo - Xo) * this.DeltaT;
        this.Y = Yo + (Xo * (this.Theta - Zo) - Yo) * this.DeltaT;
        this.Z = Zo + (Xo * Yo - this.Beta * Zo) * this.DeltaT;
        if (Math.abs(this.X) > 100.0) {
            this.X = 1.0 / this.X;
        }
        if (Math.abs(this.Y) > 100.0) {
            this.Y = 1.0 / this.Y;
        }
        if (Math.abs(this.Z) > 100.0) {
            this.Z = 1.0 / this.Z;
        }
    }

    public double getBeta() {
        return this.Beta;
    }

    public void setBeta(double beta) {
        this.Beta = beta;
    }

    public double getDeltaT() {
        return this.DeltaT;
    }

    public void setDeltaT(double deltaT) {
        this.DeltaT = deltaT;
    }

    public double getGamma() {
        return this.Gamma;
    }

    public void setGamma(double gamma) {
        this.Gamma = gamma;
    }

    public double getTheta() {
        return this.Theta;
    }

    public void setTheta(double theta) {
        this.Theta = theta;
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public double getZ() {
        return this.Z;
    }
}

