/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.math.chaos;

import com.valhalanetworks.utils.math.chaos.Atractor;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;

public strictfp class AtractorPickover
implements Atractor {
    private double X;
    private double Y;
    private double Z;
    private double Alpha = -0.759494;
    private double Beta = 2.449367;
    private double Gamma = 1.253165;
    private double Delta = 1.5;
    private MersenneTwisterPlus rnd = new MersenneTwisterPlus();

    public AtractorPickover() {
        this.X = this.rnd.nextDouble();
        this.Y = this.rnd.nextDouble();
        this.Z = this.rnd.nextDouble();
    }

    @Override
    public void SetInitialPoint(double X0, double Y0, double Z0) {
        this.X = X0;
        this.Y = Y0;
        this.Z = Z0;
    }

    public int getNumAtractorTypes() {
        return 20;
    }

    public void SetAtractorType(int N) {
        switch (N) {
            case 0: {
                this.Alpha = 11.786;
                this.Beta = 18.221;
                this.Gamma = 6.59;
                this.Delta = 0.095;
                break;
            }
            case 1: {
                this.Alpha = 0.666;
                this.Beta = 0.705;
                this.Gamma = -0.225;
                this.Delta = 2.934;
                break;
            }
            case 2: {
                this.Alpha = 1.508;
                this.Beta = 0.24;
                this.Gamma = -2.247;
                this.Delta = 2.715;
                break;
            }
            case 3: {
                this.Alpha = 2.293;
                this.Beta = 2.317;
                this.Gamma = 2.612;
                this.Delta = 1.424;
                break;
            }
            case 4: {
                this.Alpha = -1.07;
                this.Beta = 0.119;
                this.Gamma = 0.224;
                this.Delta = 2.751;
                break;
            }
            case 5: {
                this.Alpha = 2.857;
                this.Beta = 2.146;
                this.Gamma = -2.894;
                this.Delta = 0.088;
                break;
            }
            case 6: {
                this.Alpha = -2.916;
                this.Beta = 0.507;
                this.Gamma = -1.38;
                this.Delta = 0.756;
                break;
            }
            case 7: {
                this.Alpha = 2.231;
                this.Beta = 1.064;
                this.Gamma = 1.523;
                this.Delta = 1.445;
                break;
            }
            case 8: {
                this.Alpha = -0.566;
                this.Beta = 1.865;
                this.Gamma = 1.928;
                this.Delta = 1.967;
                break;
            }
            case 9: {
                this.Alpha = 0.509;
                this.Beta = 0.616;
                this.Gamma = -0.101;
                this.Delta = 2.135;
                break;
            }
            case 10: {
                this.Alpha = 2.859;
                this.Beta = 1.552;
                this.Gamma = 2.753;
                this.Delta = 2.494;
                break;
            }
            case 11: {
                this.Alpha = 2.176;
                this.Beta = 0.688;
                this.Gamma = -1.864;
                this.Delta = 1.363;
                break;
            }
            case 12: {
                this.Alpha = -2.224;
                this.Beta = 0.031;
                this.Gamma = 0.274;
                this.Delta = 2.062;
                break;
            }
            case 13: {
                this.Alpha = 2.571;
                this.Beta = 2.369;
                this.Gamma = -1.755;
                this.Delta = 0.546;
                break;
            }
            case 14: {
                this.Alpha = 2.979;
                this.Beta = 0.524;
                this.Gamma = -1.536;
                this.Delta = 0.271;
                break;
            }
            case 15: {
                this.Alpha = -1.464;
                this.Beta = 2.752;
                this.Gamma = 1.93;
                this.Delta = 1.241;
                break;
            }
            case 16: {
                this.Alpha = 2.921;
                this.Beta = 1.759;
                this.Gamma = -2.104;
                this.Delta = 0.126;
                break;
            }
            case 17: {
                this.Alpha = -2.834;
                this.Beta = 2.407;
                this.Gamma = -1.851;
                this.Delta = 0.496;
                break;
            }
            case 18: {
                this.Alpha = -2.383;
                this.Beta = 1.339;
                this.Gamma = 0.841;
                this.Delta = 2.749;
                break;
            }
            case 19: {
                this.Alpha = -2.643;
                this.Beta = 0.373;
                this.Gamma = 0.945;
                this.Delta = 2.414;
                break;
            }
            default: {
                this.Alpha = -0.759494;
                this.Beta = 2.449367;
                this.Gamma = 1.253165;
                this.Delta = 1.5;
            }
        }
    }

    @Override
    public void NextPoint() {
        double Xo = this.X;
        double Yo = this.Y;
        double Zo = this.Z;
        this.X = Math.sin(this.Alpha * Yo) - Zo * Math.cos(this.Beta * Xo);
        this.Y = Zo * Math.sin(this.Gamma * Xo) - Math.cos(this.Delta * Yo);
        this.Z = Math.sin(Xo);
    }

    public double getBeta() {
        return this.Beta;
    }

    public void setBeta(double beta) {
        this.Beta = beta;
    }

    public double getDelta() {
        return this.Delta;
    }

    public void setDelta(double delta) {
        this.Delta = delta;
    }

    public double getGamma() {
        return this.Gamma;
    }

    public void setGamma(double gamma) {
        this.Gamma = gamma;
    }

    public double getAlpha() {
        return this.Alpha;
    }

    public void setAlpha(double alpha) {
        this.Alpha = alpha;
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public double getZ() {
        return this.Z;
    }
}

