/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.numericalalgorith;

import com.valhalanetworks.utils.exception.UtilsException;

public strictfp class Matrix {
    private double[][] values;
    public static final int EMPTY_MATRIX = 1;
    public static final int ROW_OUT_RANGE = 2;
    public static final int COLUMN_OUT_RANGE = 3;
    public static final int ROWS_OF_MATRIXS_DONT_MATCH = 4;
    public static final int COLUMNS_OF_MATRIXS_DONT_MATCH = 5;
    public static final int PARAMETER_NULL = 6;
    public static final int COLUMNS_ROW_OF_MATRIXS_DONT_MATCH = 7;
    public static final int NOT_SQUARE_MATRIX = 8;
    public static final int SINGULAR_MATRIX = 9;

    public Matrix() {
        this.values = null;
    }

    public Matrix(double[][] NewValues) {
        if (NewValues != null) {
            int numrows = NewValues.length;
            int numcolumns = NewValues[0].length;
            this.values = new double[numrows][numcolumns];
            for (int row = 0; row < numrows; ++row) {
                for (int column = 0; column < numcolumns; ++column) {
                    this.values[row][column] = NewValues[row][column];
                }
            }
        } else {
            this.values = null;
        }
    }

    public Matrix(int NewRow, int NewColumns) {
        if (NewRow > 0 && NewColumns > 0) {
            this.values = new double[NewRow][NewColumns];
            int numrows = this.values.length;
            int numcolumns = this.values[0].length;
            for (int row = 0; row < NewRow; ++row) {
                for (int column = 0; column < NewColumns; ++column) {
                    this.values[row][column] = 0.0;
                }
            }
        } else {
            this.values = null;
        }
    }

    public Matrix(Matrix Other) {
        if (Other != null) {
            int numrows = Other.values.length;
            int numcolumns = Other.values[0].length;
            this.values = new double[numrows][numcolumns];
            for (int row = 0; row < numrows; ++row) {
                for (int column = 0; column < numcolumns; ++column) {
                    this.values[row][column] = Other.values[row][column];
                }
            }
        } else {
            this.values = null;
        }
    }

    public int getRowsNumber() {
        int Salida = this.values != null ? this.values.length : 0;
        return Salida;
    }

    public int getColumnNumber() {
        int Salida = this.values != null ? this.values[0].length : 0;
        return Salida;
    }

    public void setRowsNumber(int NewRow) throws UtilsException {
        double[][] NewValues;
        if (NewRow > 0) {
            int numcolumns;
            int numrows;
            if (this.values != null) {
                numrows = this.values.length;
                numcolumns = this.values[0].length;
            } else {
                this.values = new double[1][1];
                this.values[0][0] = 0.0;
                numrows = this.values.length;
                numcolumns = this.values[0].length;
            }
            NewValues = new double[NewRow][numcolumns];
            for (int row = 0; row < NewRow; ++row) {
                for (int column = 0; column < numcolumns; ++column) {
                    NewValues[row][column] = row < numrows ? this.values[row][column] : 0.0;
                }
            }
        } else {
            throw new UtilsException("ERROR: Valor de la Fila esta fuera de rango", 2);
        }
        this.values = NewValues;
    }

    public void setColumnsNumber(int NewColumns) throws UtilsException {
        double[][] NewValues;
        if (NewColumns > 0) {
            int numcolumns;
            int numrows;
            if (this.values != null) {
                numrows = this.values.length;
                numcolumns = this.values[0].length;
            } else {
                this.values = new double[1][1];
                this.values[0][0] = 0.0;
                numrows = this.values.length;
                numcolumns = this.values[0].length;
            }
            NewValues = new double[numrows][NewColumns];
            for (int column = 0; column < NewColumns; ++column) {
                for (int row = 0; row < numrows; ++row) {
                    NewValues[row][column] = column < numcolumns ? this.values[row][column] : 0.0;
                }
            }
        } else {
            throw new UtilsException("ERROR: Valor de la Columna esta fuera de rango", 3);
        }
        this.values = NewValues;
    }

    public void removeColumn(int DelColumn) throws UtilsException {
        double[][] NewValues;
        if (DelColumn >= 0 && DelColumn < this.values[0].length) {
            int numrows = this.values.length;
            int numcolumns = this.values[0].length;
            NewValues = new double[numrows][numcolumns - 1];
            int Ncolumn = 0;
            for (int column = 0; column < numcolumns; ++column) {
                if (column == DelColumn) continue;
                for (int row = 0; row < numrows; ++row) {
                    NewValues[row][Ncolumn] = this.values[row][column];
                }
                ++Ncolumn;
            }
        } else {
            throw new UtilsException("ERROR: Valor de la Columna esta fuera de rango", 3);
        }
        this.values = NewValues;
    }

    public void removeRow(int DelRow) throws UtilsException {
        double[][] NewValues;
        if (DelRow >= 0 && DelRow < this.values.length) {
            int numrows = this.values.length;
            int numcolumns = this.values[0].length;
            NewValues = new double[numrows - 1][numcolumns];
            int NRow = 0;
            for (int row = 0; row < numrows; ++row) {
                if (row == DelRow) continue;
                for (int column = 0; column < numcolumns; ++column) {
                    NewValues[NRow][column] = this.values[row][column];
                }
                ++NRow;
            }
        } else {
            throw new UtilsException("ERROR: Valor de la Fila esta fuera de rango", 2);
        }
        this.values = NewValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeRowColumn(int DelRow, int DelColumn) throws UtilsException {
        if (DelRow < 0 || DelRow >= this.values.length) throw new UtilsException("ERROR: Valor de la Fila esta fuera de rango", 2);
        if (DelColumn < 0 || DelColumn >= this.values[0].length) throw new UtilsException("ERROR: Valor de la Columna esta fuera de rango", 3);
        int numrows = this.values.length;
        int numcolumns = this.values[0].length;
        double[][] NewValues = new double[numrows - 1][numcolumns - 1];
        int NRow = 0;
        for (int row = 0; row < numrows; ++row) {
            if (row == DelRow) continue;
            int NColumn = 0;
            for (int column = 0; column < numcolumns; ++column) {
                if (column == DelColumn) continue;
                NewValues[NRow][NColumn] = this.values[row][column];
                ++NColumn;
            }
            ++NRow;
        }
        this.values = NewValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMatrixSize(int NewRow, int NewColumns) throws UtilsException {
        int numcolumns;
        int numrows;
        if (NewRow <= 0) throw new UtilsException("ERROR: Valor de la Fila esta fuera de rango", 2);
        if (NewColumns <= 0) throw new UtilsException("ERROR: Valor de la Columna esta fuera de rango", 3);
        if (this.values != null) {
            numrows = this.values.length;
            numcolumns = this.values[0].length;
        } else {
            this.values = new double[1][1];
            this.values[0][0] = 0.0;
            numrows = this.values.length;
            numcolumns = this.values[0].length;
        }
        double[][] NewValues = new double[NewRow][NewColumns];
        for (int row = 0; row < NewRow; ++row) {
            for (int column = 0; column < NewColumns; ++column) {
                NewValues[row][column] = row < numrows && column < numcolumns ? this.values[row][column] : 0.0;
            }
        }
        this.values = NewValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getValue(int row, int column) throws UtilsException {
        double Salida = 0.0;
        if (this.values == null) throw new UtilsException("ERROR: La matriz esta vacia", 1);
        if (row < 0) throw new UtilsException("ERROR: Valor de la Fila esta fuera de rango", 2);
        if (row >= this.values.length) throw new UtilsException("ERROR: Valor de la Fila esta fuera de rango", 2);
        if (column < 0) throw new UtilsException("ERROR: Valor de la Columna esta fuera de rango", 3);
        if (column >= this.values[0].length) throw new UtilsException("ERROR: Valor de la Columna esta fuera de rango", 3);
        return this.values[row][column];
    }

    public void setValue(int row, int column, double value) throws UtilsException {
        if (row >= 0 && row < this.values.length) {
            if (column < 0 || column >= this.values[0].length) {
                throw new UtilsException("ERROR: Valor de la Columna esta fuera de rango", 3);
            }
        } else {
            throw new UtilsException("ERROR: Valor de la Fila esta fuera de rango", 2);
        }
        this.values[row][column] = value;
    }

    public boolean isEmpty() {
        boolean Salida = false;
        if (this.values == null) {
            Salida = true;
        }
        return Salida;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Matrix Add(Matrix Other) throws UtilsException {
        Matrix Salida = null;
        if (Other == null) throw new UtilsException("ERROR: Matriz Other NULL", 6);
        if (this.values == null) throw new UtilsException("ERROR: Matriz vacia", 1);
        if (Other.values == null) throw new UtilsException("ERROR: Matriz 'Other' es vacia", 1);
        if (this.values.length != Other.values.length) throw new UtilsException("ERROR: Dimensiones de las Filas no son iguales", 4);
        if (this.values[0].length != Other.values[0].length) throw new UtilsException("ERROR: Dimensiones de las Columnas no son iguales", 5);
        int NumR = this.values.length;
        int NumC = this.values[0].length;
        Salida = new Matrix(NumR, NumC);
        for (int R = 0; R < NumR; ++R) {
            for (int C = 0; C < NumC; ++C) {
                Salida.setValue(R, C, this.values[R][C] + Other.values[R][C]);
            }
        }
        return Salida;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Matrix Subtrac(Matrix Other) throws UtilsException {
        Matrix Salida = null;
        if (Other == null) throw new UtilsException("ERROR: Matriz Other NULL", 6);
        if (this.values == null) throw new UtilsException("ERROR: Matriz vacia", 1);
        if (Other.values == null) throw new UtilsException("ERROR: Matriz 'Other' es vacia", 1);
        if (this.values.length != Other.values.length) throw new UtilsException("ERROR: Dimensiones de las Filas no son iguales", 4);
        if (this.values[0].length != Other.values[0].length) throw new UtilsException("ERROR: Dimensiones de las Columnas no son iguales", 5);
        int NumR = this.values.length;
        int NumC = this.values[0].length;
        Salida = new Matrix(NumR, NumC);
        for (int R = 0; R < NumR; ++R) {
            for (int C = 0; C < NumC; ++C) {
                Salida.setValue(R, C, this.values[R][C] - Other.values[R][C]);
            }
        }
        return Salida;
    }

    public Matrix PScalar(double Scal) throws UtilsException {
        Matrix Salida = null;
        if (this.values != null) {
            int NumR = this.values.length;
            int NumC = this.values[0].length;
            Salida = new Matrix(NumR, NumC);
            for (int R = 0; R < NumR; ++R) {
                for (int C = 0; C < NumC; ++C) {
                    Salida.setValue(R, C, Scal * this.values[R][C]);
                }
            }
        } else {
            throw new UtilsException("ERROR: Matriz vacia", 1);
        }
        return Salida;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Matrix Multi(Matrix Other) throws UtilsException {
        Matrix Salida = null;
        if (Other == null) throw new UtilsException("ERROR: Matriz Other NULL", 6);
        if (this.values == null) throw new UtilsException("ERROR: Matriz vacia", 1);
        if (Other.values == null) throw new UtilsException("ERROR: Matriz 'Other' es vacia", 1);
        if (this.values[0].length != Other.values.length) throw new UtilsException("ERROR: Dimensiones de las Columnas de A no son iguales a las Filas de B", 7);
        int NumRA = this.values.length;
        int NumCA = this.values[0].length;
        int NumRB = Other.values.length;
        int NumCB = Other.values[0].length;
        Salida = new Matrix(NumRA, NumCB);
        for (int R = 0; R < NumRA; ++R) {
            for (int C = 0; C < NumCB; ++C) {
                for (int P = 0; P < NumCA; ++P) {
                    Salida.setValue(R, C, Salida.getValue(R, C) + this.values[R][P] * Other.values[P][C]);
                }
            }
        }
        return Salida;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double Det() throws UtilsException {
        double Salida = 0.0;
        if (this.values == null) throw new UtilsException("ERROR: Matriz vacia", 1);
        if (this.values.length != this.values[0].length) throw new UtilsException("ERROR: Matriz no es cuadrada", 8);
        int NumColumns = this.values.length;
        if (NumColumns == 2) {
            return this.values[0][0] * this.values[1][1] - this.values[0][1] * this.values[1][0];
        }
        if (NumColumns == 3) {
            return this.values[0][0] * this.values[1][1] * this.values[2][2] + this.values[0][1] * this.values[1][2] * this.values[2][0] + this.values[0][2] * this.values[1][0] * this.values[2][1] - this.values[0][2] * this.values[1][1] * this.values[2][0] - this.values[0][1] * this.values[1][0] * this.values[2][2] - this.values[0][0] * this.values[1][2] * this.values[2][1];
        }
        Salida = 0.0;
        int C = 0;
        while (C < NumColumns) {
            Matrix MT = new Matrix(this);
            MT.removeRowColumn(0, C);
            Salida += Math.pow(-1.0, C) * this.values[0][C] * MT.Det();
            ++C;
        }
        return Salida;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Matrix Adjn() throws UtilsException {
        Matrix Salida = null;
        if (this.values == null) throw new UtilsException("ERROR: Matriz vacia", 1);
        if (this.values.length != this.values[0].length) throw new UtilsException("ERROR: Matriz no es cuadrada", 8);
        int NumRowsColumns = this.values.length;
        Salida = new Matrix(NumRowsColumns, NumRowsColumns);
        if (NumRowsColumns == 2) {
            Salida.setValue(0, 0, this.values[1][1]);
            Salida.setValue(0, 1, -1.0 * this.values[1][0]);
            Salida.setValue(1, 0, -1.0 * this.values[0][1]);
            Salida.setValue(1, 1, this.values[0][0]);
            return Salida.Trans();
        } else {
            for (int R = 0; R < NumRowsColumns; ++R) {
                for (int C = 0; C < NumRowsColumns; ++C) {
                    Matrix MT = new Matrix(this);
                    MT.removeRowColumn(R, C);
                    Salida.setValue(R, C, Math.pow(-1.0, R + C) * MT.Det());
                }
            }
        }
        return Salida.Trans();
    }

    public Matrix Trans() throws UtilsException {
        Matrix Salida = null;
        if (this.values != null) {
            int NumR = this.values.length;
            int NumC = this.values[0].length;
            Salida = new Matrix(NumC, NumR);
            for (int R = 0; R < NumR; ++R) {
                for (int C = 0; C < NumC; ++C) {
                    Salida.setValue(C, R, this.values[R][C]);
                }
            }
        } else {
            throw new UtilsException("ERROR: Matriz vacia", 1);
        }
        return Salida;
    }

    public Matrix Inv() throws UtilsException {
        double Determinante;
        Matrix Salida = null;
        if (this.values != null) {
            Determinante = this.Det();
            if (Determinante == 0.0) {
                throw new UtilsException("ERROR: Matriz Singular", 9);
            }
        } else {
            throw new UtilsException("ERROR: Matriz vacia", 1);
        }
        Salida = this.Adjn();
        Salida = Salida.PScalar(1.0 / Determinante);
        return Salida;
    }

    public void InitIdentidad() throws UtilsException {
        if (this.values != null) {
            int row;
            int numrows = this.values.length;
            int numcolumns = this.values[0].length;
            if (numrows != numcolumns) {
                numrows = row = Math.max(numrows, numcolumns);
                numcolumns = row;
                this.values = new double[numrows][numcolumns];
            }
            for (row = 0; row < numrows; ++row) {
                for (int column = 0; column < numcolumns; ++column) {
                    this.values[row][column] = row == column ? 1.0 : 0.0;
                }
            }
        } else {
            throw new UtilsException("ERROR: Matriz vacia", 1);
        }
    }
}

