/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.array;

import java.lang.reflect.Array;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static Object subArray(Object oldArray, int org, int length) {
        Object newArray = null;
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        if (org < oldSize) {
            if (oldSize - org < length) {
                length = oldSize - org;
            }
            newArray = Array.newInstance(elementType, length);
            System.arraycopy(oldArray, org, newArray, 0, length);
        }
        return newArray;
    }

    public static void arrayCopy(Object src, int srcPos, Object dest, int destPos, int length) {
        if (src != null && dest != null) {
            Class<?> srcElementType = src.getClass().getComponentType();
            Class<?> destElementType = dest.getClass().getComponentType();
            if (destElementType.isAssignableFrom(srcElementType)) {
                int srcSize = Array.getLength(src) - srcPos;
                int destSize = Array.getLength(dest) - destPos;
                int preserveLength = Math.min(srcSize, destSize);
                if ((preserveLength = Math.min(preserveLength, length)) > 0) {
                    System.arraycopy(src, srcPos, dest, destPos, preserveLength);
                }
            }
        }
    }

    public static Object arrayTrim(Object[] oldArray) {
        int posB;
        Class<?> elementType = oldArray.getClass().getComponentType();
        int posA = oldArray.length;
        for (posB = 0; posB < oldArray.length && oldArray[posB] != null; ++posB) {
        }
        if (posB < oldArray.length) {
            posA = posB;
            while (posB < oldArray.length) {
                while (posB < oldArray.length && oldArray[posB] == null) {
                    ++posB;
                }
                if (posB >= oldArray.length) continue;
                while (posB < oldArray.length && oldArray[posB] != null) {
                    oldArray[posA] = oldArray[posB];
                    oldArray[posB] = null;
                    ++posA;
                    ++posB;
                }
            }
        }
        Object newArray = Array.newInstance(elementType, posA);
        System.arraycopy(oldArray, 0, newArray, 0, posA);
        return newArray;
    }
}

