/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.console;

import com.valhalanetworks.utils.system.SystemUtils;

public class TextRotor {
    private int Progress = 0;
    private int RotorPos = 0;
    private int MaxChars = 79;
    private int WritedChars = 3;
    private char BarChar;
    private char[] Rotor;
    private long Plot_Start_Time = -1L;
    private long Plot_End_Time = -1L;

    public TextRotor() {
        String Encoding = SystemUtils.getEncoding();
        this.BarChar = Encoding.contains("cp1252") ? (char)9619 : (Encoding.contains("iso_8859_1") || Encoding.contains("iso_8859_15") ? (char)61 : (Encoding.contains("us_ascii") || Encoding.contains("ansi_x3.4-1968") ? (char)62 : (char)9619));
        this.Rotor = new char[4];
        this.setStandarRotor();
    }

    public final void setStandarRotor() {
        this.Rotor[0] = 45;
        this.Rotor[1] = 92;
        this.Rotor[2] = 124;
        this.Rotor[3] = 47;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCustomRotor(char[] NewRotor) {
        if (NewRotor != null && NewRotor.length == 4) {
            int i = 0;
            while (i < 4) {
                void var2_2;
                this.Rotor[var2_2] = NewRotor[var2_2];
                ++var2_2;
            }
        }
    }

    public String ResetProgressBar() {
        String Salida = "\r";
        for (int i = 0; i < this.WritedChars; ++i) {
            Salida = Salida + " ";
        }
        Salida = Salida + "\r";
        Salida = Salida + "0% ";
        this.WritedChars = 3;
        return Salida;
    }

    public void setMaxChars(int MaxChars) {
        if (MaxChars > 4) {
            this.MaxChars = MaxChars;
        }
    }

    public void setBarChar(char BarChar) {
        this.BarChar = BarChar;
    }

    public String DrawRotor() {
        switch (this.RotorPos) {
            case 0: {
                ++this.RotorPos;
                return "\b" + this.Rotor[0];
            }
            case 1: {
                ++this.RotorPos;
                return "\b" + this.Rotor[1];
            }
            case 2: {
                ++this.RotorPos;
                return "\b" + this.Rotor[2];
            }
            case 3: {
                this.RotorPos = 0;
                return "\b" + this.Rotor[3];
            }
        }
        this.RotorPos = 0;
        return "\b" + this.Rotor[0];
    }

    public String DrawProgressBar(int Porcent) {
        String Salida = "";
        if (Porcent >= 0 && Porcent <= 100) {
            int NumNewChars = Porcent * (this.MaxChars - 4) / 100 + 3 - this.WritedChars;
            if (NumNewChars > 0) {
                if (this.Progress < 10) {
                    Salida = "\b\b\b";
                    this.WritedChars -= 3;
                } else {
                    Salida = "\b\b\b\b";
                    this.WritedChars -= 4;
                }
                for (int i = 0; i < NumNewChars; ++i) {
                    Salida = Salida + this.BarChar;
                }
                this.WritedChars += NumNewChars;
                this.Progress = Porcent;
                Salida = Salida + String.valueOf(this.Progress) + "% ";
                this.WritedChars += String.valueOf(this.Progress).length() + 2;
            } else if (NumNewChars < 0) {
                if (this.Progress < 10) {
                    Salida = "\b \b\b \b\b \b";
                    this.WritedChars -= 3;
                } else {
                    Salida = "\b \b\b \b\b \b\b \b";
                    this.WritedChars -= 4;
                }
                NumNewChars = -NumNewChars;
                for (int i = 0; i < NumNewChars; ++i) {
                    Salida = Salida + "\b \b";
                }
                this.WritedChars -= NumNewChars;
                this.Progress = Porcent;
                Salida = Salida + String.valueOf(this.Progress) + "% ";
                this.WritedChars += String.valueOf(this.Progress).length() + 2;
            }
            if (this.Progress < 100) {
                Salida = Salida + this.DrawRotor();
            } else {
                Salida = Salida + "\b";
                --this.WritedChars;
            }
        }
        return Salida;
    }

    public String PlotProgressBar(int Porcent) {
        double difference;
        String Salida = "";
        if (this.Plot_Start_Time == -1L) {
            difference = 1.0;
        } else {
            this.Plot_End_Time = System.nanoTime();
            difference = (double)(this.Plot_End_Time - this.Plot_Start_Time) / 1.0E9;
        }
        if (difference >= 0.03 || Porcent == 100) {
            Salida = this.DrawProgressBar(Porcent);
            this.Plot_Start_Time = System.nanoTime();
        }
        return Salida;
    }

    public void ResetTimerPlotProgressBar() {
        this.Plot_Start_Time = -1L;
    }

    public String PlotRotor() {
        double difference;
        String Salida = "";
        if (this.Plot_Start_Time == -1L) {
            difference = 1.0;
        } else {
            this.Plot_End_Time = System.nanoTime();
            difference = (double)(this.Plot_End_Time - this.Plot_Start_Time) / 1.0E9;
        }
        if (difference >= 0.03) {
            Salida = this.DrawRotor();
            this.Plot_Start_Time = System.nanoTime();
        }
        return Salida;
    }

    public void ResetTimerPlotRotor() {
        this.Plot_Start_Time = -1L;
    }
}

