/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.disruptor;

import com.valhalanetworks.utils.disruptor.ProcessingSequenceBarrier;
import com.valhalanetworks.utils.disruptor.Sequence;
import com.valhalanetworks.utils.disruptor.SequenceBarrier;
import com.valhalanetworks.utils.disruptor.SequenceGroups;
import com.valhalanetworks.utils.disruptor.Sequencer;
import com.valhalanetworks.utils.disruptor.WaitStrategy;
import com.valhalanetworks.utils.disruptor.util.Util;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class AbstractSequencer
implements Sequencer {
    private static final AtomicReferenceFieldUpdater<AbstractSequencer, Sequence[]> SEQUENCE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractSequencer.class, Sequence[].class, "gatingSequences");
    protected final int bufferSize;
    protected final WaitStrategy waitStrategy;
    protected final Sequence cursor = new Sequence(-1L);
    protected volatile Sequence[] gatingSequences = new Sequence[0];

    public AbstractSequencer(int bufferSize, WaitStrategy waitStrategy) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        if (Integer.bitCount(bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.bufferSize = bufferSize;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public final long getCursor() {
        return this.cursor.get();
    }

    @Override
    public final int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public final void addGatingSequences(Sequence ... gatingSequences) {
        SequenceGroups.addSequences(this, SEQUENCE_UPDATER, this, gatingSequences);
    }

    @Override
    public boolean removeGatingSequence(Sequence sequence) {
        return SequenceGroups.removeSequence(this, SEQUENCE_UPDATER, sequence);
    }

    @Override
    public long getMinimumSequence() {
        return Util.getMinimumSequence(this.gatingSequences, this.cursor.get());
    }

    @Override
    public SequenceBarrier newBarrier(Sequence ... sequencesToTrack) {
        return new ProcessingSequenceBarrier(this, this.waitStrategy, this.cursor, sequencesToTrack);
    }
}

