/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.disruptor;

import com.valhalanetworks.utils.disruptor.Cursored;
import com.valhalanetworks.utils.disruptor.Sequence;
import com.valhalanetworks.utils.disruptor.SequenceGroups;
import com.valhalanetworks.utils.disruptor.util.Util;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class SequenceGroup
extends Sequence {
    private static final AtomicReferenceFieldUpdater<SequenceGroup, Sequence[]> SEQUENCE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SequenceGroup.class, Sequence[].class, "sequences");
    private volatile Sequence[] sequences = new Sequence[0];

    public SequenceGroup() {
        super(-1L);
    }

    @Override
    public long get() {
        return Util.getMinimumSequence(this.sequences);
    }

    @Override
    public void set(long value) {
        Sequence[] sequences = this.sequences;
        int size = sequences.length;
        for (int i = 0; i < size; ++i) {
            sequences[i].set(value);
        }
    }

    public void add(Sequence sequence) {
        Sequence[] newSequences;
        Sequence[] oldSequences;
        do {
            oldSequences = this.sequences;
            int oldSize = oldSequences.length;
            newSequences = new Sequence[oldSize + 1];
            System.arraycopy(oldSequences, 0, newSequences, 0, oldSize);
            newSequences[oldSize] = sequence;
        } while (!SEQUENCE_UPDATER.compareAndSet(this, oldSequences, newSequences));
    }

    public boolean remove(Sequence sequence) {
        return SequenceGroups.removeSequence(this, SEQUENCE_UPDATER, sequence);
    }

    public int size() {
        return this.sequences.length;
    }

    public void addWhileRunning(Cursored cursored, Sequence sequence) {
        SequenceGroups.addSequences(this, SEQUENCE_UPDATER, cursored, sequence);
    }
}

