/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.numericalalgorith;

import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.numericalalgorith.NAFunction;

public strictfp class DormandPrince {
    private NAFunction Fxt;
    private double h;
    private double IterationTargetError;
    private double xMax;
    private double x0;
    private double y0;
    public static final int ErrorGeneric = 1;
    public static final int ErrorIterationTargetErrorNotReached = 2;
    public static final int ErrorNotEnoughMemory = 3;

    public DormandPrince(NAFunction Fxt) {
        this.Fxt = Fxt;
        this.IterationTargetError = 1.0E-6;
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.h = 1.0E-6;
        this.xMax = 1.0 / this.h;
    }

    public double getXMax() {
        return this.xMax;
    }

    public void setXMax(double xMax) {
        this.xMax = xMax;
    }

    public void setInitialConditions(double x0, double y0) {
        this.x0 = x0;
        this.y0 = y0;
    }

    public double getTimeInterval() {
        return this.h;
    }

    public void setTimeInterval(double h) {
        this.h = h;
    }

    public double getTargetError() {
        return this.IterationTargetError;
    }

    public void setTargetError(double IterationTargetError) {
        this.IterationTargetError = IterationTargetError;
    }

    private void ButcherTableau(double[] k, double x, double y) throws UtilsException {
        double[] t = new double[]{x, y};
        k[0] = this.h * this.Fxt.Eval(t);
        t[0] = x + this.h / 5.0;
        t[1] = y + k[0] / 5.0;
        k[1] = this.h * this.Fxt.Eval(t);
        t[0] = x + 3.0 * this.h / 10.0;
        t[1] = y + 3.0 * k[0] / 40.0 + 9.0 * k[1] / 40.0;
        k[2] = this.h * this.Fxt.Eval(t);
        t[0] = x + 4.0 * this.h / 5.0;
        t[1] = y + 44.0 * k[0] / 45.0 - 56.0 * k[1] / 15.0 + 39.0 * k[2] / 2.0;
        k[3] = this.h * this.Fxt.Eval(t);
        t[0] = x + 8.0 * this.h / 9.0;
        t[1] = y + 19372.0 * k[0] / 6561.0 - 25360.0 * k[1] / 2187.0 + 64448.0 * k[2] / 6561.0 - 212.0 * k[3] / 729.0;
        k[4] = this.h * this.Fxt.Eval(t);
        t[0] = x + this.h;
        t[1] = y + 9017.0 * k[0] / 3168.0 - 355.0 * k[1] / 33.0 - 46732.0 * k[2] / 5247.0 + 49.0 * k[3] / 176.0 - 5103.0 * k[4] / 18656.0;
        k[5] = this.h * this.Fxt.Eval(t);
        t[0] = x + this.h;
        t[1] = y + 35.0 * k[0] / 384.0 + 500.0 * k[2] / 1113.0 + 125.0 * k[3] / 192.0 - 2187.0 * k[4] / 6784.0 + 11.0 * k[5] / 84.0;
        k[6] = this.h * this.Fxt.Eval(t);
    }

    private double[][] VectorResize(double[][] X, int length) throws UtilsException {
        int i;
        double[][] Y = null;
        try {
            Y = new double[length][2];
        }
        catch (Exception e) {
            throw new UtilsException("Generic Error: " + e.getMessage(), 1);
        }
        catch (OutOfMemoryError e) {
            throw new UtilsException("ERROR: NOT Enough Memory, try to reduce Iteration Target Error...", 3);
        }
        for (i = 0; i < length; ++i) {
            Y[i][0] = 0.0;
            Y[i][1] = 0.0;
        }
        if (X != null) {
            int max = Math.min(X.length, length);
            for (i = 0; i < max; ++i) {
                Y[i][0] = X[i][0];
                Y[i][1] = X[i][1];
            }
        }
        return Y;
    }

    public double[][] Resolve() throws UtilsException {
        if (Math.abs(this.xMax - this.x0) < 1.0E-7) {
            double[][] Salida = new double[1][2];
            Salida[0][0] = this.x0;
            Salida[0][1] = this.y0;
            return Salida;
        }
        double[][] Salida = this.VectorResize(null, (int)(1000.0 * Math.abs(this.xMax - this.x0) / Math.abs(this.h)));
        double[] k = new double[7];
        double x = this.x0;
        double y = this.y0;
        int tamano = 0;
        int NumIteraciones = 0;
        while (x <= this.xMax) {
            double hnext;
            this.ButcherTableau(k, x, y);
            double Error2 = Math.abs(71.0 * k[0] / 57600.0 - 71.0 * k[2] / 16695.0 + 71.0 * k[3] / 1920.0 - 17253.0 * k[4] / 339200.0 + 22.0 * k[5] / 525.0 - 1.0 * k[6] / 40.0);
            if (Error2 < this.IterationTargetError) {
                y = y + 35.0 * k[0] / 384.0 + 500.0 * k[2] / 1113.0 + 125.0 * k[3] / 192.0 - 2187.0 * k[4] / 6784.0 + 11.0 * k[5] / 84.0;
                Salida[tamano][0] = x;
                Salida[tamano][1] = y;
                x += this.h;
                if (++tamano == Salida.length) {
                    Salida = this.VectorResize(Salida, 10 * tamano);
                }
                NumIteraciones = 0;
                continue;
            }
            double s = this.IterationTargetError * this.h / (2.0 * Error2);
            s = Math.pow(s, 0.2);
            this.h = hnext = s * this.h;
            if (NumIteraciones > 10000 * Salida.length) {
                throw new UtilsException("ERROR: Target Error NOT reached", 2);
            }
            ++NumIteraciones;
            int NewTamano = tamano + Math.abs((int)(Math.abs(this.xMax - x) / Math.abs(this.h)));
            if (NewTamano <= Salida.length) continue;
            Salida = this.VectorResize(Salida, NewTamano);
        }
        Salida = this.VectorResize(Salida, tamano);
        return Salida;
    }
}

