/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.random;

import com.valhalanetworks.utils.math.chaos.AtractorLorenz;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.random.sparkers.Sparker;

public strictfp class KAOSrand {
    private static final int LIMIT = 256;
    private AtractorLorenz[] Atractores;
    private MersenneTwisterPlus rnd;
    private static long Mask;
    private int Jump = -1;

    private void RandomIntialPoints() {
        if (this.Atractores != null) {
            int j;
            int i;
            double Xo = 0.0;
            double Yo = 0.0;
            double Zo = 0.0;
            for (i = 0; i < this.Atractores.length; ++i) {
                for (j = 0; j < this.rnd.nextByte(); ++j) {
                    Xo = 255.0 * this.rnd.nextDouble();
                }
                for (j = 0; j < this.rnd.nextByte(); ++j) {
                    Yo = 255.0 * this.rnd.nextDouble();
                }
                for (j = 0; j < this.rnd.nextByte(); ++j) {
                    Zo = 255.0 * this.rnd.nextDouble();
                }
                this.Atractores[i].SetInitialPoint(Xo, Yo, Zo);
            }
            i = 0;
            j = 0;
            Xo = 0.0;
            Yo = 0.0;
            Zo = 0.0;
        }
    }

    private void Sparkerizar(Sparker Sprk) {
        if (this.Atractores != null) {
            if (Sprk != null) {
                int j;
                double Zo;
                double Yo;
                double Xo;
                int i;
                this.Jump = Sprk.getShortSpark() % 256;
                for (i = 0; i < this.Atractores.length; ++i) {
                    Xo = 255.0 * Sprk.getDoubleSpark();
                    Yo = 255.0 * Sprk.getDoubleSpark();
                    Zo = 255.0 * Sprk.getDoubleSpark();
                    this.Atractores[i].SetInitialPoint(Xo, Yo, Zo);
                    for (j = 0; j < this.Jump; ++j) {
                        this.Atractores[i].NextPoint();
                    }
                }
                i = 0;
                j = 0;
                Xo = 0.0;
                Yo = 0.0;
                Zo = 0.0;
            } else {
                this.RandomIntialPoints();
            }
        }
    }

    public KAOSrand() {
        Mask = Long.MAX_VALUE;
        this.rnd = new MersenneTwisterPlus();
        this.Atractores = new AtractorLorenz[12];
        for (int i = 0; i < this.Atractores.length; ++i) {
            this.Atractores[i] = new AtractorLorenz();
            this.Atractores[i].SetAtractorType(i);
        }
        this.RandomIntialPoints();
    }

    public KAOSrand(Sparker Sprk) {
        Mask = Long.MAX_VALUE;
        this.rnd = new MersenneTwisterPlus();
        this.Atractores = new AtractorLorenz[12];
        for (int i = 0; i < this.Atractores.length; ++i) {
            this.Atractores[i] = new AtractorLorenz();
            this.Atractores[i].SetAtractorType(i);
        }
        if (Sprk != null) {
            this.Sparkerizar(Sprk);
        } else {
            this.RandomIntialPoints();
        }
    }

    public double nextDouble() {
        int i;
        int k = 3;
        double[] coordenada = new double[k * this.Atractores.length];
        for (i = 0; i < this.Atractores.length; ++i) {
            int j;
            if (this.Jump <= 0) {
                for (j = 0; j < this.rnd.nextShort() % 256; ++j) {
                    this.Atractores[i].NextPoint();
                }
            } else {
                for (j = 0; j < this.Jump; ++j) {
                    this.Atractores[i].NextPoint();
                }
            }
            coordenada[k * i] = this.Atractores[i].getX();
            coordenada[k * i + 1] = this.Atractores[i].getY();
            coordenada[k * i + 2] = this.Atractores[i].getZ();
        }
        for (i = 0; i < k * this.Atractores.length; ++i) {
            if (coordenada[i] < 0.0) {
                int n = i;
                coordenada[n] = coordenada[n] * -1.0;
            }
            coordenada[i] = coordenada[i] - (double)((long)coordenada[i]);
        }
        long Aleatorios = 0L;
        for (i = 0; i < k * this.Atractores.length; ++i) {
            Aleatorios <<= 12;
            Aleatorios ^= Double.doubleToRawLongBits(coordenada[i]) & 0xFFFFFFFFFFFFFL;
        }
        for (i = 0; i < k * this.Atractores.length; ++i) {
            coordenada[i] = 0.0;
        }
        coordenada[0] = (double)(Aleatorios &= 0x1FFFFFFFFFFFFFL) * 1.1102230246251568E-16;
        return coordenada[0];
    }

    public long nextLong() {
        return (long)((double)Mask * this.nextDouble());
    }

    public long nextLong63() {
        return (long)((double)(Mask >>> 1) * this.nextDouble());
    }

    public int nextInt() {
        return (int)((double)(Mask >>> 32) * this.nextDouble());
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.nextInt31() >> 31);
        }
        while ((bits = this.nextInt31()) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public int nextInt31() {
        return (int)((double)(Mask >>> 33) * this.nextDouble());
    }

    public short nextShort() {
        return (short)((double)(Mask >>> 48) * this.nextDouble());
    }

    public short nextShort15() {
        return (short)((double)(Mask >>> 49) * this.nextDouble());
    }

    public byte nextByte() {
        return (byte)((double)(Mask >>> 56) * this.nextDouble());
    }

    public byte nextByte7() {
        return (byte)((double)(Mask >>> 57) * this.nextDouble());
    }

    /*
     * WARNING - void declaration
     */
    public void nextBytes(byte[] bytes) {
        if (bytes != null) {
            int i = 0;
            while (i < bytes.length) {
                void var2_2;
                bytes[var2_2] = this.nextByte();
                ++var2_2;
            }
        }
    }
}

