/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.random;

public class MersenneTwisterPlus {
    private int NN = 312;
    private int MM = 156;
    private long MATRIX_A = -5403634167711393303L;
    private long UM = Integer.MIN_VALUE;
    private long LM = Integer.MAX_VALUE;
    private long[] mt;
    private int mti;
    private long seed;
    private boolean FixedSeed;
    private int MaxCiclo;
    private int Ciclo;

    private long GenSeed() {
        return System.currentTimeMillis();
    }

    private void init_genrand64() {
        this.MaxCiclo = (int)(this.seed % 990L) + 10;
        this.Ciclo = 0;
        this.mt = new long[this.NN];
        this.mt[0] = this.seed;
        this.mti = 1;
        while (this.mti < this.NN) {
            this.mt[this.mti] = 6364136223846793005L * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 62) + (long)this.mti;
            ++this.mti;
        }
        this.mti = this.NN + 1;
    }

    public MersenneTwisterPlus() {
        this.FixedSeed = false;
        this.seed = this.GenSeed();
        this.init_genrand64();
    }

    public MersenneTwisterPlus(long seed) {
        this.FixedSeed = true;
        this.seed = seed;
        this.init_genrand64();
    }

    public long nextLong() {
        long x;
        long[] magVN = new long[]{0L, this.MATRIX_A};
        if (!this.FixedSeed && this.Ciclo >= this.MaxCiclo) {
            this.seed = this.GenSeed();
            this.init_genrand64();
        }
        if (this.mti >= this.NN) {
            int i;
            for (i = 0; i < this.NN - this.MM; ++i) {
                x = this.mt[i] & this.UM | this.mt[i + 1] & this.LM;
                this.mt[i] = this.mt[i + this.MM] ^ x >>> 1 ^ magVN[(int)(x & 1L)];
            }
            while (i < this.NN - 1) {
                x = this.mt[i] & this.UM | this.mt[i + 1] & this.LM;
                this.mt[i] = this.mt[i + (this.MM - this.NN)] ^ x >>> 1 ^ magVN[(int)(x & 1L)];
                ++i;
            }
            x = this.mt[this.NN - 1] & this.UM | this.mt[0] & this.LM;
            this.mt[this.NN - 1] = this.mt[this.MM - 1] ^ x >>> 1 ^ magVN[(int)(x & 1L)];
            this.mti = 0;
            if (!this.FixedSeed) {
                ++this.Ciclo;
            }
        }
        x = this.mt[this.mti++];
        x ^= x >>> 29 & 0x5555555555555555L;
        x ^= x << 17 & 0x71D67FFFEDA60000L;
        x ^= x << 37 & 0xFFF7EEE000000000L;
        x ^= x >>> 43;
        return x;
    }

    public long nextLong63() {
        return this.nextLong() >>> 1;
    }

    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * 1.1102230246251568E-16;
    }

    public double nextReal() {
        return (double)(this.nextLong() >>> 11) * 1.1102230246251568E-16;
    }

    public double nextReal2() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    public double nextReal3() {
        return ((double)(this.nextLong() >>> 12) + 0.5) * 2.220446049250313E-16;
    }

    public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.nextInt31() >> 31);
        }
        while ((bits = this.nextInt31()) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public int nextInt31() {
        return (int)(this.nextLong() >>> 33);
    }

    public short nextShort() {
        return (short)(this.nextLong() >>> 48);
    }

    public short nextShort15() {
        return (short)(this.nextLong() >>> 49);
    }

    public byte nextByte() {
        return (byte)(this.nextLong() >>> 56);
    }

    public byte nextByte7() {
        return (byte)(this.nextLong() >>> 57);
    }

    /*
     * WARNING - void declaration
     */
    public void nextBytes(byte[] bytes) {
        if (bytes != null) {
            int i = 0;
            while (i < bytes.length) {
                void var2_2;
                bytes[var2_2] = this.nextByte();
                ++var2_2;
            }
        }
    }
}

