/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.utils.vthreads.dsrKernelTasks;

import com.valhalanetworks.utils.array.ArrayUtils;
import com.valhalanetworks.utils.disruptor.EventFactory;
import com.valhalanetworks.utils.disruptor.EventHandler;
import com.valhalanetworks.utils.disruptor.RingBuffer;
import com.valhalanetworks.utils.disruptor.TimeoutException;
import com.valhalanetworks.utils.disruptor.WaitStrategy;
import com.valhalanetworks.utils.disruptor.dsl.Disruptor;
import com.valhalanetworks.utils.disruptor.dsl.ProducerType;
import com.valhalanetworks.utils.exception.UtilsException;
import com.valhalanetworks.utils.random.MersenneTwisterPlus;
import com.valhalanetworks.utils.sort.Searcher;
import com.valhalanetworks.utils.sort.Sorter;
import com.valhalanetworks.utils.vthreads.dsrthreads.VDsrRunnable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class VDsrKernelTasks<T> {
    public static final int FACTORYNOTDEFINED = -1;
    public static final int RUNNABLENOTADDED = -2;
    public static final int TIMEOUT = -3;
    public static final int KERNELNOTINITIALIZATED = -4;
    protected Executor executor = Executors.newCachedThreadPool();
    protected VDsrRunnable<T>[] RunnablesList;
    protected int bufferSize = 2048;
    protected Disruptor<T> disruptor = null;
    protected EventFactory<T> factory;

    public VDsrKernelTasks() {
        this.factory = null;
        this.RunnablesList = null;
    }

    public VDsrKernelTasks(EventFactory<T> factory) {
        this.RunnablesList = null;
        this.factory = factory;
    }

    public final EventFactory<T> getFactory() {
        return this.factory;
    }

    public final void setFactory(EventFactory<T> factory) {
        this.factory = factory;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int bufferSize) {
        if (bufferSize > 2) {
            int Temp = (int)(Math.log(bufferSize) / Math.log(2.0));
            this.bufferSize = (int)Math.pow(2.0, Temp);
        }
    }

    public final void InitKernet(ProducerType producerType, WaitStrategy waitStrategy) throws UtilsException {
        if (this.disruptor != null) {
            this.disruptor.shutdown();
        }
        if (this.factory == null) {
            throw new UtilsException("ERROR: Factory not defined", -1);
        }
        this.disruptor = new Disruptor<T>(this.factory, this.bufferSize, this.executor, producerType, waitStrategy);
        for (int i = 0; i < this.RunnablesList.length; ++i) {
            this.RunnablesList[i].setRingBuffer(this.disruptor.getRingBuffer());
            if (this.RunnablesList[i].getHandler() != null) {
                this.disruptor.handleEventsWith(this.RunnablesList[i].getHandler());
            }
            this.executor.execute(this.RunnablesList[i]);
        }
    }

    public void Start() throws UtilsException {
        if (this.disruptor == null) {
            throw new UtilsException("ERROR: VDsrKernel NOT Initializated ", -4);
        }
        this.disruptor.start();
    }

    /*
     * WARNING - void declaration
     */
    public void Shutdown() throws UtilsException {
        if (this.RunnablesList != null) {
            int i = 0;
            while (i < this.RunnablesList.length) {
                void var1_1;
                this.RunnablesList[var1_1].Finish();
                ++var1_1;
            }
        }
        if (this.disruptor != null) {
            try {
                this.disruptor.shutdown(1000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                throw new UtilsException("ERROR: Shutdown Time Out", -3);
            }
        }
    }

    public RingBuffer<T> getRingBuffer() throws UtilsException {
        if (this.disruptor != null) {
            return this.disruptor.getRingBuffer();
        }
        throw new UtilsException("ERROR: VDsrKernel NOT Initializated ", -4);
    }

    public void setEventHandler(EventHandler<T> ... Handlers) throws UtilsException {
        if (this.disruptor == null) {
            throw new UtilsException("ERROR: VDsrKernel NOT Initializated ", -4);
        }
        this.disruptor.handleEventsWith(Handlers);
    }

    public void after(EventHandler<T> ... Handlers) throws UtilsException {
        if (this.disruptor == null) {
            throw new UtilsException("ERROR: VDsrKernel NOT Initializated ", -4);
        }
        this.disruptor.after(Handlers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addVDsrRunnable(VDsrRunnable<T> Runnable2) throws UtilsException {
        int Longitud = 0;
        if (this.RunnablesList == null) {
            this.RunnablesList = new VDsrRunnable[1];
            this.RunnablesList[Longitud] = Runnable2;
            return;
        } else {
            int Counter;
            MersenneTwisterPlus Random2 = new MersenneTwisterPlus();
            VDsrRunnable Objet2Find = new VDsrRunnable();
            Objet2Find.setVDsrRunnableID(Runnable2.getVDsrRunnableID());
            for (Counter = 10000; Searcher.AbsoluteSearch(this.RunnablesList, Objet2Find) != -1 && Counter > 0; --Counter) {
                Objet2Find.setVDsrRunnableID(Random2.nextLong());
            }
            if (Counter <= 0) throw new UtilsException("ERROR: NO Availabre ID found", -2);
            Runnable2.setVDsrRunnableID(Objet2Find.getVDsrRunnableID());
            Longitud = this.RunnablesList.length;
            this.RunnablesList = (VDsrRunnable[])ArrayUtils.resizeArray(this.RunnablesList, Longitud + 1);
            if (this.RunnablesList.length != Longitud + 1) throw new UtilsException("ERROR: NO memory to add Runnable", -2);
            this.RunnablesList[Longitud] = Runnable2;
            Sorter.AbsoluteSort(this.RunnablesList, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public long[] getVDsrRunnableIDs() {
        long[] IDs = null;
        if (this.RunnablesList != null) {
            IDs = new long[this.RunnablesList.length];
            int i = 0;
            while (i < this.RunnablesList.length) {
                void var1_2;
                IDs[var1_2] = this.RunnablesList[var1_2].getVDsrRunnableID();
                ++var1_2;
            }
        }
        return IDs;
    }

    public VDsrRunnable<T> getRunnable(long ID) {
        VDsrRunnable<T> Salida = null;
        if (this.RunnablesList != null) {
            VDsrRunnable Objet2Find = new VDsrRunnable();
            Objet2Find.setVDsrRunnableID(ID);
            int Pos = Searcher.AbsoluteSearch(this.RunnablesList, Objet2Find);
            if (Pos != -1) {
                Salida = this.RunnablesList[Pos];
            }
        }
        return Salida;
    }

    public int FinishRunnable(long ID) {
        int Salida = -1;
        if (this.RunnablesList != null) {
            VDsrRunnable Objet2Find = new VDsrRunnable();
            Objet2Find.setVDsrRunnableID(ID);
            int Pos = Searcher.AbsoluteSearch(this.RunnablesList, Objet2Find);
            if (Pos != -1) {
                this.RunnablesList[Pos].Finish();
                this.RunnablesList[Pos] = null;
                ArrayUtils.arrayTrim(this.RunnablesList);
                Salida = 0;
            }
        }
        return Salida;
    }
}

