/*
 * Decompiled with CFR 0.152.
 */
package com.valhalanetworks.cryptography.digest;

import com.valhalanetworks.cryptography.digest.BaseHash;
import com.valhalanetworks.cryptography.digest.StringUtils;
import java.nio.charset.StandardCharsets;

public class CRC32
extends BaseHash {
    private static final int BLOCK_SIZE = 4;
    private static final String DIGEST0 = "22F9AFAD";
    private int crc = 0;
    private static int[] crc_table = CRC32.make_crc_table();

    private static int[] make_crc_table() {
        int[] crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            crc_table[n] = c;
        }
        return crc_table;
    }

    public CRC32() {
        super("crc32", 4, 4);
        this.crc = 0;
    }

    public CRC32(CRC32 md) {
        super("crc32", 4, 4);
        this.crc = md.crc;
    }

    @Override
    public Object clone() {
        return new CRC32(this);
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    @Override
    public void reset() {
        this.crc = 0;
    }

    public void update(int bval) {
        int c = ~this.crc;
        c = crc_table[(c ^ bval) & 0xFF] ^ c >>> 8;
        this.crc = ~c;
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        int c = ~this.crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        this.crc = ~c;
    }

    public void update(byte[] buf) {
        this.update(buf, 0, buf.length);
    }

    @Override
    public byte[] digest() {
        long val = this.getValue();
        return new byte[]{(byte)(val >>> 24 & 0xFFL), (byte)(val >>> 16 & 0xFFL), (byte)(val >>> 8 & 0xFFL), (byte)(val & 0xFFL)};
    }

    @Override
    public boolean selfTest() {
        return DIGEST0.equals(StringUtils.toString(this.Hash("CCPTCRC32".getBytes(StandardCharsets.ISO_8859_1))));
    }

    @Override
    protected byte[] padBuffer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected byte[] getResult() {
        return this.digest();
    }

    @Override
    protected void resetContext() {
        this.reset();
    }

    @Override
    protected void transform(byte[] in, int offset) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

